/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.compiler.util.scan;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.codehaus.plexus.compiler.util.scan.AbstractSourceInclusionScanner;
import org.codehaus.plexus.compiler.util.scan.InclusionScanException;
import org.codehaus.plexus.compiler.util.scan.mapping.SourceMapping;
import org.codehaus.plexus.util.DirectoryScanner;

public class StaleSourceScanner
extends AbstractSourceInclusionScanner {
    private final long lastUpdatedWithinMsecs;
    private final Set sourceIncludes;
    private final Set sourceExcludes;

    public StaleSourceScanner(long lastUpdatedWithinMsecs) {
        this(lastUpdatedWithinMsecs, Collections.singleton("**/*"), Collections.EMPTY_SET);
    }

    public StaleSourceScanner() {
        this(0L, Collections.singleton("**/*"), Collections.EMPTY_SET);
    }

    public StaleSourceScanner(long lastUpdatedWithinMsecs, Set sourceIncludes, Set sourceExcludes) {
        this.lastUpdatedWithinMsecs = lastUpdatedWithinMsecs;
        this.sourceIncludes = sourceIncludes;
        this.sourceExcludes = sourceExcludes;
    }

    public Set getIncludedSources(File sourceDir, File targetDir) throws InclusionScanException {
        List srcMappings = this.getSourceMappings();
        if (srcMappings.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        HashSet<File> matchingSources = new HashSet<File>();
        String[] potentialIncludes = this.scanForSources(sourceDir);
        block0: for (int i = 0; i < potentialIncludes.length; ++i) {
            String path = potentialIncludes[i];
            File sourceFile = new File(sourceDir, path);
            Iterator patternIt = srcMappings.iterator();
            while (patternIt.hasNext()) {
                SourceMapping mapping = (SourceMapping)patternIt.next();
                Set targetFiles = mapping.getTargetFiles(targetDir, path);
                Iterator targetIt = targetFiles.iterator();
                while (targetIt.hasNext()) {
                    File targetFile = (File)targetIt.next();
                    if (targetFile.exists() && targetFile.lastModified() + this.lastUpdatedWithinMsecs >= sourceFile.lastModified()) continue;
                    matchingSources.add(sourceFile);
                    continue block0;
                }
            }
        }
        return matchingSources;
    }

    private String[] scanForSources(File sourceDir) {
        DirectoryScanner ds = new DirectoryScanner();
        ds.setFollowSymlinks(true);
        ds.setBasedir(sourceDir);
        String[] includes = null;
        includes = this.sourceIncludes.isEmpty() ? new String[]{} : this.sourceIncludes.toArray(new String[this.sourceIncludes.size()]);
        ds.setIncludes(includes);
        String[] excludes = null;
        excludes = this.sourceExcludes.isEmpty() ? new String[]{} : this.sourceExcludes.toArray(new String[this.sourceExcludes.size()]);
        ds.setExcludes(excludes);
        ds.addDefaultExcludes();
        ds.scan();
        return ds.getIncludedFiles();
    }
}

