/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.taskqueue.execution;

import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Startable;
import org.codehaus.plexus.taskqueue.Task;
import org.codehaus.plexus.taskqueue.TaskQueue;
import org.codehaus.plexus.taskqueue.TaskQueueException;
import org.codehaus.plexus.taskqueue.execution.TaskExecutor;
import org.codehaus.plexus.taskqueue.execution.TaskQueueExecutor;
import org.codehaus.plexus.util.StringUtils;

public class ThreadedTaskQueueExecutor
extends AbstractLogEnabled
implements TaskQueueExecutor,
Initializable,
Startable {
    private TaskQueue queue;
    private TaskExecutor executor;
    private String name;
    private ExecutorRunnable executorRunnable;
    private Thread executorThread;

    public void initialize() throws Exception {
        if (StringUtils.isEmpty((String)this.name)) {
            throw new IllegalArgumentException("'name' must be set.");
        }
    }

    public void start() throws Exception {
        this.getLogger().info("Starting task executor, thread name '" + this.name + "'.");
        this.executorRunnable = new ExecutorRunnable();
        this.executorThread = new Thread(this.executorRunnable);
        this.executorThread.setDaemon(true);
        this.executorThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws Exception {
        int maxSleep = 10000;
        int interval = 1000;
        int slept = 0;
        this.executorRunnable.shutdown();
        this.executorThread.interrupt();
        while (!this.executorRunnable.isDone()) {
            if (slept > maxSleep) {
                this.getLogger().warn("Timeout, stopping task executor '" + this.name + ".");
                break;
            }
            this.getLogger().info("Waiting until task executor '" + this.name + "' is idling...");
            try {
                Thread thread = this.executorThread;
                synchronized (thread) {
                    this.executorThread.wait(interval);
                }
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            slept += interval;
        }
    }

    private class ExecutorRunnable
    implements Runnable {
        private boolean shutdown;
        private boolean done;

        private ExecutorRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!this.shutdown) {
                Task task;
                try {
                    task = ThreadedTaskQueueExecutor.this.queue.take();
                }
                catch (TaskQueueException e) {
                    ThreadedTaskQueueExecutor.this.getLogger().error("Error while getting task from the task queue.", (Throwable)e);
                    continue;
                }
                if (task == null) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException ex) {}
                    continue;
                }
                try {
                    ThreadedTaskQueueExecutor.this.executor.executeTask(task);
                }
                catch (Throwable e) {
                    ThreadedTaskQueueExecutor.this.getLogger().error("Error while executing task.", e);
                }
            }
            ThreadedTaskQueueExecutor.this.getLogger().info("Executor thread '" + ThreadedTaskQueueExecutor.this.name + "' exited.");
            this.done = true;
            ExecutorRunnable executorRunnable = this;
            synchronized (executorRunnable) {
                this.notifyAll();
            }
        }

        public void shutdown() {
            ThreadedTaskQueueExecutor.this.getLogger().info("Executor thread got shutdown signal.");
            this.shutdown = true;
        }

        public boolean isDone() {
            return this.done;
        }
    }
}

