/*
 * Decompiled with CFR 0.152.
 */
package plus.jdk.websocket.global;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrameAggregator;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.handler.codec.http.websocketx.extensions.compression.WebSocketServerCompressionHandler;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.AttributeKey;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.charset.Charset;
import org.springframework.beans.TypeMismatchException;
import org.springframework.util.StringUtils;
import plus.jdk.websocket.common.WebsocketCommonException;
import plus.jdk.websocket.global.WebSocketServerHandler;
import plus.jdk.websocket.global.WebsocketDispatcher;
import plus.jdk.websocket.global.WebsocketMethodMapping;
import plus.jdk.websocket.properties.WebsocketProperties;

public class HttpServerHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private final WebsocketProperties properties;
    private final WebsocketDispatcher websocketDispatcher;
    private final NioEventLoopGroup eventLoopGroup;

    public HttpServerHandler(WebsocketProperties properties, WebsocketDispatcher websocketDispatcher, NioEventLoopGroup worker) {
        this.properties = properties;
        this.websocketDispatcher = websocketDispatcher;
        this.eventLoopGroup = worker;
    }

    protected void channelRead0(ChannelHandlerContext ctx, FullHttpRequest msg) throws Exception {
        try {
            this.handleHttpRequest(ctx, msg);
        }
        catch (TypeMismatchException e) {
            DefaultFullHttpResponse res = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.BAD_REQUEST);
            HttpServerHandler.sendHttpResponse(ctx, msg, (FullHttpResponse)res);
            e.printStackTrace();
        }
        catch (Exception e) {
            DefaultFullHttpResponse res = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.INTERNAL_SERVER_ERROR);
            HttpServerHandler.sendHttpResponse(ctx, msg, (FullHttpResponse)res);
            e.printStackTrace();
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        this.websocketDispatcher.doOnError(ctx.channel(), cause);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.websocketDispatcher.doOnClose(ctx.channel());
        super.channelInactive(ctx);
    }

    private void handleHttpRequest(ChannelHandlerContext ctx, FullHttpRequest req) throws WebsocketCommonException {
        WebSocketServerHandshakerFactory wsFactory;
        WebSocketServerHandshaker handshaker;
        if (!req.decoderResult().isSuccess()) {
            DefaultFullHttpResponse res = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.BAD_REQUEST);
            HttpServerHandler.sendHttpResponse(ctx, req, (FullHttpResponse)res);
            return;
        }
        if (req.method() != HttpMethod.GET) {
            DefaultFullHttpResponse res = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.FORBIDDEN);
            HttpServerHandler.sendHttpResponse(ctx, req, (FullHttpResponse)res);
            return;
        }
        HttpHeaders headers = req.headers();
        String host = headers.get((CharSequence)HttpHeaderNames.HOST);
        if (StringUtils.isEmpty((Object)host)) {
            DefaultFullHttpResponse res = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.FORBIDDEN);
            HttpServerHandler.sendHttpResponse(ctx, req, (FullHttpResponse)res);
            return;
        }
        if (!(StringUtils.isEmpty((Object)this.properties.getHost()) || this.properties.getHost().equals("0.0.0.0") || this.properties.getHost().equals(host.split(":")[0]))) {
            DefaultFullHttpResponse res = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.FORBIDDEN);
            HttpServerHandler.sendHttpResponse(ctx, req, (FullHttpResponse)res);
            return;
        }
        QueryStringDecoder decoder = new QueryStringDecoder(req.uri());
        String path = decoder.path();
        Channel channel = ctx.channel();
        WebsocketMethodMapping websocketMethodMapping = this.websocketDispatcher.getWebsocketMethodMap().get(path);
        if (websocketMethodMapping == null) {
            DefaultFullHttpResponse res = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_FOUND);
            HttpServerHandler.sendHttpResponse(ctx, req, (FullHttpResponse)res);
            return;
        }
        if (!(req.headers().contains((CharSequence)HttpHeaderNames.UPGRADE) && req.headers().contains((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_KEY) && req.headers().contains((CharSequence)HttpHeaderNames.SEC_WEBSOCKET_VERSION))) {
            DefaultFullHttpResponse res = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.FORBIDDEN);
            HttpServerHandler.sendHttpResponse(ctx, req, (FullHttpResponse)res);
            return;
        }
        String subprotocols = null;
        if (this.websocketDispatcher.hasBeforeHandshake(channel, path)) {
            this.websocketDispatcher.doBeforeHandshake(channel, req, path);
            if (!channel.isActive()) {
                return;
            }
            AttributeKey subprotocolsAttrKey = AttributeKey.valueOf((String)"subprotocols");
            if (channel.hasAttr(subprotocolsAttrKey)) {
                subprotocols = (String)ctx.channel().attr(subprotocolsAttrKey).get();
            }
        }
        if ((handshaker = (wsFactory = new WebSocketServerHandshakerFactory(HttpServerHandler.getWebSocketLocation(req), subprotocols, true, this.properties.getMaxFramePayloadLength().intValue())).newHandshaker((HttpRequest)req)) == null) {
            WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse((Channel)channel);
        } else {
            ChannelPipeline pipeline = ctx.pipeline();
            pipeline.remove(ctx.name());
            if (this.properties.getReaderIdleTimeSeconds() != 0 || this.properties.getWriterIdleTimeSeconds() != 0 || this.properties.getAllIdleTimeSeconds() != 0) {
                pipeline.addLast(new ChannelHandler[]{new IdleStateHandler(this.properties.getReaderIdleTimeSeconds().intValue(), this.properties.getWriterIdleTimeSeconds().intValue(), this.properties.getAllIdleTimeSeconds().intValue())});
            }
            if (this.properties.getUseCompressionHandler().booleanValue()) {
                pipeline.addLast(new ChannelHandler[]{new WebSocketServerCompressionHandler()});
            }
            pipeline.addLast(new ChannelHandler[]{new WebSocketFrameAggregator(Integer.MAX_VALUE)});
            if (this.properties.getUseEventExecutorGroup().booleanValue()) {
                pipeline.addLast((EventExecutorGroup)this.eventLoopGroup, new ChannelHandler[]{new WebSocketServerHandler(this.websocketDispatcher)});
            } else {
                pipeline.addLast(new ChannelHandler[]{new WebSocketServerHandler(this.websocketDispatcher)});
            }
            handshaker.handshake(channel, req).addListener(future -> {
                if (future.isSuccess()) {
                    this.websocketDispatcher.doOnOpen(channel, req, path);
                } else {
                    handshaker.close(channel, new CloseWebSocketFrame());
                }
            });
        }
    }

    private static void sendHttpResponse(ChannelHandlerContext ctx, FullHttpRequest req, FullHttpResponse res) {
        int statusCode = res.status().code();
        if (statusCode != HttpResponseStatus.OK.code() && res.content().readableBytes() == 0) {
            ByteBuf buf = Unpooled.copiedBuffer((CharSequence)res.status().toString(), (Charset)CharsetUtil.UTF_8);
            res.content().writeBytes(buf);
            buf.release();
        }
        HttpUtil.setContentLength((HttpMessage)res, (long)res.content().readableBytes());
        ChannelFuture f = ctx.channel().writeAndFlush((Object)res);
        if (!HttpUtil.isKeepAlive((HttpMessage)req) || statusCode != 200) {
            f.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    private static String getWebSocketLocation(FullHttpRequest req) {
        String location = req.headers().get((CharSequence)HttpHeaderNames.HOST) + req.uri();
        return "ws://" + location;
    }
}

