/*
 * Decompiled with CFR 0.152.
 */
package plus.jdk.websocket.support;

import io.netty.channel.Channel;
import java.lang.reflect.Method;
import org.springframework.core.MethodParameter;
import plus.jdk.websocket.annotations.OnWsError;
import plus.jdk.websocket.support.MethodArgumentResolver;

public class ThrowableMethodArgumentResolver
implements MethodArgumentResolver {
    @Override
    public boolean supportsParameter(MethodParameter parameter) {
        Method method = parameter.getMethod();
        if (method == null) {
            return false;
        }
        return method.isAnnotationPresent(OnWsError.class) && Throwable.class.isAssignableFrom(parameter.getParameterType());
    }

    @Override
    public Object resolveArgument(MethodParameter parameter, Channel channel, Object object) throws Exception {
        if (object instanceof Throwable) {
            return object;
        }
        return null;
    }
}

