/*
 * Decompiled with CFR 0.152.
 */
package plus.jdk.websocket.global;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import plus.jdk.broadcast.model.Monitor;
import plus.jdk.websocket.global.IWSSessionAuthenticatorManager;
import plus.jdk.websocket.global.UserChannelConnectSynchronizer;
import plus.jdk.websocket.model.ChannelModel;
import plus.jdk.websocket.model.IWsSession;
import plus.jdk.websocket.properties.WebsocketProperties;
import plus.jdk.websocket.protoc.MessageType;

public class SessionGroupManager {
    private static final Logger log = LoggerFactory.getLogger(SessionGroupManager.class);
    private final ConcurrentHashMap<Channel, ChannelModel> channelModelMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<Object, ConcurrentHashMap<String, ConcurrentLinkedDeque<IWsSession<?>>>> sessionMap = new ConcurrentHashMap();
    private final BeanFactory beanFactory;
    private final WebsocketProperties properties;

    public SessionGroupManager(BeanFactory beanFactory, WebsocketProperties properties) {
        this.beanFactory = beanFactory;
        this.properties = properties;
    }

    protected void addSession(String path, IWsSession<?> iWsSession) {
        Object uid = iWsSession.getUserId();
        this.sessionMap.putIfAbsent(uid, new ConcurrentHashMap());
        this.sessionMap.get(uid).putIfAbsent(path, new ConcurrentLinkedDeque());
        this.sessionMap.get(uid).get(path).add(iWsSession);
        this.channelModelMap.put(iWsSession.getChannel(), new ChannelModel(uid, path));
    }

    public <T> ConcurrentLinkedDeque<IWsSession<?>> getSession(T userId, String path) {
        ConcurrentHashMap<String, ConcurrentLinkedDeque<IWsSession<?>>> userSessionMap = this.sessionMap.get(userId);
        if (userSessionMap == null || userSessionMap.get(path) == null) {
            return new ConcurrentLinkedDeque();
        }
        return this.sessionMap.get(userId).get(path);
    }

    public <U> void sendBinary(U userId, String path, byte[] data) {
        this.sendMessage(userId, path, data, MessageType.MESSAGE_TYPE_BINARY);
    }

    public <U> void sendText(U userId, String path, String data) {
        this.sendMessage(userId, path, data.getBytes(StandardCharsets.UTF_8), MessageType.MESSAGE_TYPE_TEXT);
    }

    protected <U> void sendMessage(U userId, String path, byte[] data, MessageType messageType) {
        UserChannelConnectSynchronizer synchronizer = (UserChannelConnectSynchronizer)this.beanFactory.getBean(UserChannelConnectSynchronizer.class);
        IWSSessionAuthenticatorManager sessionAuthManager = (IWSSessionAuthenticatorManager)this.beanFactory.getBean(this.properties.getSessionAuthenticator());
        Monitor[] monitors = sessionAuthManager.getUserConnectedMachine(userId, path, this.properties);
        synchronizer.sendBroadcast(userId, path, data, monitors, messageType);
    }

    protected void releaseChannel(ChannelHandlerContext ctx) {
        Channel channel = ctx.channel();
        ChannelModel channelModel = this.channelModelMap.get(channel);
        Object uid = channelModel.getUserId();
        String path = channelModel.getPath();
        this.sessionMap.putIfAbsent(uid, new ConcurrentHashMap());
        this.sessionMap.get(uid).putIfAbsent(path, new ConcurrentLinkedDeque());
        ConcurrentLinkedDeque<IWsSession<?>> wsSessionsDeque = this.sessionMap.get(uid).get(path);
        if (wsSessionsDeque == null) {
            return;
        }
        wsSessionsDeque.removeIf(iWsSession -> {
            if (iWsSession.getChannel() == channel) {
                try {
                    IWSSessionAuthenticatorManager sessionAuthManager = (IWSSessionAuthenticatorManager)this.beanFactory.getBean(this.properties.getSessionAuthenticator());
                    sessionAuthManager.onSessionDestroy((IWsSession<?>)iWsSession, path, this.properties);
                }
                catch (Exception e) {
                    log.error(e.getMessage());
                }
                return true;
            }
            return false;
        });
    }
}

