/*
 * Decompiled with CFR 0.152.
 */
package plus.jdk.websocket.global;

import com.google.protobuf.ByteString;
import java.util.Arrays;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import plus.jdk.broadcast.broadcaster.UdpBroadcastMessageMonitor;
import plus.jdk.broadcast.broadcaster.UdpMessageBroadcaster;
import plus.jdk.broadcast.broadcaster.model.BroadcastMessage;
import plus.jdk.broadcast.model.Monitor;
import plus.jdk.broadcast.properties.BroadCastProperties;
import plus.jdk.websocket.global.IWSSessionAuthenticatorManager;
import plus.jdk.websocket.global.SessionGroupManager;
import plus.jdk.websocket.model.IWsSession;
import plus.jdk.websocket.properties.WebsocketProperties;
import plus.jdk.websocket.protoc.MessageType;
import plus.jdk.websocket.protoc.WsMessage;

public class UserChannelConnectSynchronizer
implements ApplicationRunner {
    private static final Logger log = LoggerFactory.getLogger(UserChannelConnectSynchronizer.class);
    private final BeanFactory beanFactory;
    private final WebsocketProperties properties;
    private final UdpBroadcastMessageMonitor udpBroadcastMessageMonitor;
    private final UdpMessageBroadcaster udpMessageBroadcaster;
    private final IWSSessionAuthenticatorManager<?, ? extends IWsSession<?>> clusterChannelManager;
    private final Monitor[] clusterMonitors;

    public UserChannelConnectSynchronizer(BeanFactory beanFactory, WebsocketProperties properties) {
        this.beanFactory = beanFactory;
        this.properties = properties;
        BroadCastProperties broadCastProperties = new BroadCastProperties();
        broadCastProperties.setMonitorPort(properties.getBroadcastMonitorPort());
        this.udpBroadcastMessageMonitor = new UdpBroadcastMessageMonitor(broadCastProperties);
        this.udpMessageBroadcaster = new UdpMessageBroadcaster(broadCastProperties);
        this.clusterChannelManager = (IWSSessionAuthenticatorManager)beanFactory.getBean(properties.getSessionAuthenticator());
        this.clusterMonitors = this.clusterChannelManager.getAllUdpMonitors(properties);
    }

    protected void sendBroadcast(Object userId, String path, byte[] data, Monitor[] monitors, MessageType messageType) {
        WsMessage.Builder builder = WsMessage.newBuilder();
        builder.setData(ByteString.copyFrom((byte[])data));
        builder.setUid(userId == null ? "" : userId.toString());
        builder.setPath(path);
        builder.setType(messageType);
        WsMessage wsMessage = builder.build();
        this.udpMessageBroadcaster.publish(new BroadcastMessage(wsMessage.toByteArray(), Arrays.asList(monitors)));
    }

    public void run(ApplicationArguments args) throws Exception {
        if (this.properties.getBroadcastMonitorPort() <= 0) {
            return;
        }
        Thread thread = new Thread(() -> this.udpBroadcastMessageMonitor.subscribe((ctx, msg) -> {
            WsMessage wsMessage = WsMessage.parseFrom(msg.getContent());
            SessionGroupManager sessionGroupManager = (SessionGroupManager)this.beanFactory.getBean(SessionGroupManager.class);
            ConcurrentLinkedDeque<IWsSession<?>> sessions = sessionGroupManager.getSession(wsMessage.getUid(), wsMessage.getPath());
            if (this.properties.getPrintBroadcastMessage().booleanValue()) {
                log.info("receive broadcast message: {}", (Object)wsMessage);
            }
            for (IWsSession<?> session : sessions) {
                if (MessageType.MESSAGE_TYPE_TEXT.equals((Object)wsMessage.getType())) {
                    session.sendText(new String(wsMessage.getData().toByteArray()));
                }
                if (!MessageType.MESSAGE_TYPE_BINARY.equals((Object)wsMessage.getType())) continue;
                session.sendBinary(wsMessage.getData().toByteArray());
            }
            return true;
        }));
        thread.start();
    }
}

