/*
 * Decompiled with CFR 0.152.
 */
package plus.jdk.websocket.global;

import io.netty.channel.Channel;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.support.AbstractBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.core.MethodParameter;
import org.springframework.core.ParameterNameDiscoverer;
import plus.jdk.websocket.common.WebsocketCommonException;
import plus.jdk.websocket.support.ByteMethodArgumentResolver;
import plus.jdk.websocket.support.EventMethodArgumentResolver;
import plus.jdk.websocket.support.HttpHeadersMethodArgumentResolver;
import plus.jdk.websocket.support.MethodArgumentResolver;
import plus.jdk.websocket.support.RequestParamMapMethodArgumentResolver;
import plus.jdk.websocket.support.RequestParamMethodArgumentResolver;
import plus.jdk.websocket.support.SessionMethodArgumentResolver;
import plus.jdk.websocket.support.TextMethodArgumentResolver;
import plus.jdk.websocket.support.ThrowableMethodArgumentResolver;

public class WebsocketMethodMapping {
    private static final ParameterNameDiscoverer parameterNameDiscoverer = new DefaultParameterNameDiscoverer();
    private String path;
    private Class<?> handlerClazz;
    private Object beanObject;
    private Method onOpenMethod;
    private Method onMessageMethod;
    private Method onCloseMethod;
    private Method beforeHandshake;
    private Method onErrorMethod;
    private Method onBinaryMethod;
    private Method onEventMethod;
    private MethodParameter[] beforeHandshakeParameters;
    private MethodParameter[] onOpenParameters;
    private MethodParameter[] onCloseParameters;
    private MethodParameter[] onErrorParameters;
    private MethodParameter[] onMessageParameters;
    private MethodParameter[] onBinaryParameters;
    private MethodParameter[] onEventParameters;
    private MethodArgumentResolver[] beforeHandshakeArgResolvers;
    private MethodArgumentResolver[] onOpenArgResolvers;
    private MethodArgumentResolver[] onCloseArgResolvers;
    private MethodArgumentResolver[] onErrorArgResolvers;
    private MethodArgumentResolver[] onMessageArgResolvers;
    private MethodArgumentResolver[] onBinaryArgResolvers;
    private MethodArgumentResolver[] onEventArgResolvers;
    private ApplicationContext applicationContext;
    private AbstractBeanFactory beanFactory;

    public WebsocketMethodMapping(ApplicationContext context, AbstractBeanFactory beanFactory) throws WebsocketCommonException {
        this.applicationContext = context;
        this.beanFactory = beanFactory;
    }

    public void buildParameters() throws WebsocketCommonException {
        this.beforeHandshakeParameters = WebsocketMethodMapping.getParameters(this.beforeHandshake);
        this.onOpenParameters = WebsocketMethodMapping.getParameters(this.onOpenMethod);
        this.onCloseParameters = WebsocketMethodMapping.getParameters(this.onCloseMethod);
        this.onMessageParameters = WebsocketMethodMapping.getParameters(this.onMessageMethod);
        this.onErrorParameters = WebsocketMethodMapping.getParameters(this.onErrorMethod);
        this.onBinaryParameters = WebsocketMethodMapping.getParameters(this.onBinaryMethod);
        this.onEventParameters = WebsocketMethodMapping.getParameters(this.onEventMethod);
        this.beforeHandshakeArgResolvers = this.getResolvers(this.beforeHandshakeParameters);
        this.onOpenArgResolvers = this.getResolvers(this.onOpenParameters);
        this.onCloseArgResolvers = this.getResolvers(this.onCloseParameters);
        this.onMessageArgResolvers = this.getResolvers(this.onMessageParameters);
        this.onErrorArgResolvers = this.getResolvers(this.onErrorParameters);
        this.onBinaryArgResolvers = this.getResolvers(this.onBinaryParameters);
        this.onEventArgResolvers = this.getResolvers(this.onEventParameters);
    }

    private Object[] getMethodArgumentValues(Channel channel, Object object, MethodParameter[] parameters, MethodArgumentResolver[] resolvers) throws Exception {
        Object[] objects = new Object[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            Object arg;
            MethodParameter parameter = parameters[i];
            MethodArgumentResolver resolver = resolvers[i];
            if (resolver == null) continue;
            objects[i] = arg = resolver.resolveArgument(parameter, channel, object);
        }
        return objects;
    }

    public Object[] getBeforeHandshakeArgs(Channel channel, FullHttpRequest req) throws Exception {
        return this.getMethodArgumentValues(channel, req, this.beforeHandshakeParameters, this.beforeHandshakeArgResolvers);
    }

    public Object[] getOnOpenArgs(Channel channel, FullHttpRequest req) throws Exception {
        return this.getMethodArgumentValues(channel, req, this.onOpenParameters, this.onOpenArgResolvers);
    }

    public Object[] getOnCloseArgs(Channel channel) throws Exception {
        return this.getMethodArgumentValues(channel, null, this.onCloseParameters, this.onCloseArgResolvers);
    }

    public Object[] getOnErrorArgs(Channel channel, Throwable throwable) throws Exception {
        return this.getMethodArgumentValues(channel, throwable, this.onErrorParameters, this.onErrorArgResolvers);
    }

    public Object[] getOnMessageArgs(Channel channel, TextWebSocketFrame textWebSocketFrame) throws Exception {
        return this.getMethodArgumentValues(channel, textWebSocketFrame, this.onMessageParameters, this.onMessageArgResolvers);
    }

    public Object[] getOnBinaryArgs(Channel channel, BinaryWebSocketFrame binaryWebSocketFrame) throws Exception {
        return this.getMethodArgumentValues(channel, binaryWebSocketFrame, this.onBinaryParameters, this.onBinaryArgResolvers);
    }

    public Object[] getOnEventArgs(Channel channel, Object evt) throws Exception {
        return this.getMethodArgumentValues(channel, evt, this.onEventParameters, this.onEventArgResolvers);
    }

    private MethodArgumentResolver[] getResolvers(MethodParameter[] parameters) throws WebsocketCommonException {
        MethodArgumentResolver[] methodArgumentResolvers = new MethodArgumentResolver[parameters.length];
        List<MethodArgumentResolver> resolvers = this.getDefaultResolvers();
        block0: for (int i = 0; i < parameters.length; ++i) {
            MethodParameter parameter = parameters[i];
            for (MethodArgumentResolver resolver : resolvers) {
                if (!resolver.supportsParameter(parameter)) continue;
                methodArgumentResolvers[i] = resolver;
                continue block0;
            }
        }
        return methodArgumentResolvers;
    }

    private List<MethodArgumentResolver> getDefaultResolvers() {
        ArrayList<MethodArgumentResolver> resolvers = new ArrayList<MethodArgumentResolver>();
        resolvers.add(new SessionMethodArgumentResolver());
        resolvers.add(new HttpHeadersMethodArgumentResolver());
        resolvers.add(new TextMethodArgumentResolver());
        resolvers.add(new ThrowableMethodArgumentResolver());
        resolvers.add(new ByteMethodArgumentResolver());
        resolvers.add(new RequestParamMapMethodArgumentResolver());
        resolvers.add(new RequestParamMethodArgumentResolver(this.beanFactory));
        resolvers.add(new EventMethodArgumentResolver(this.beanFactory));
        return resolvers;
    }

    private static MethodParameter[] getParameters(Method m) {
        if (m == null) {
            return new MethodParameter[0];
        }
        int count = m.getParameterCount();
        MethodParameter[] result = new MethodParameter[count];
        for (int i = 0; i < count; ++i) {
            MethodParameter methodParameter = new MethodParameter(m, i);
            methodParameter.initParameterNameDiscovery(parameterNameDiscoverer);
            result[i] = methodParameter;
        }
        return result;
    }

    public String getPath() {
        return this.path;
    }

    public Class<?> getHandlerClazz() {
        return this.handlerClazz;
    }

    public Object getBeanObject() {
        return this.beanObject;
    }

    public Method getOnOpenMethod() {
        return this.onOpenMethod;
    }

    public Method getOnMessageMethod() {
        return this.onMessageMethod;
    }

    public Method getOnCloseMethod() {
        return this.onCloseMethod;
    }

    public Method getBeforeHandshake() {
        return this.beforeHandshake;
    }

    public Method getOnErrorMethod() {
        return this.onErrorMethod;
    }

    public Method getOnBinaryMethod() {
        return this.onBinaryMethod;
    }

    public Method getOnEventMethod() {
        return this.onEventMethod;
    }

    public MethodParameter[] getBeforeHandshakeParameters() {
        return this.beforeHandshakeParameters;
    }

    public MethodParameter[] getOnOpenParameters() {
        return this.onOpenParameters;
    }

    public MethodParameter[] getOnCloseParameters() {
        return this.onCloseParameters;
    }

    public MethodParameter[] getOnErrorParameters() {
        return this.onErrorParameters;
    }

    public MethodParameter[] getOnMessageParameters() {
        return this.onMessageParameters;
    }

    public MethodParameter[] getOnBinaryParameters() {
        return this.onBinaryParameters;
    }

    public MethodParameter[] getOnEventParameters() {
        return this.onEventParameters;
    }

    public MethodArgumentResolver[] getBeforeHandshakeArgResolvers() {
        return this.beforeHandshakeArgResolvers;
    }

    public MethodArgumentResolver[] getOnOpenArgResolvers() {
        return this.onOpenArgResolvers;
    }

    public MethodArgumentResolver[] getOnCloseArgResolvers() {
        return this.onCloseArgResolvers;
    }

    public MethodArgumentResolver[] getOnErrorArgResolvers() {
        return this.onErrorArgResolvers;
    }

    public MethodArgumentResolver[] getOnMessageArgResolvers() {
        return this.onMessageArgResolvers;
    }

    public MethodArgumentResolver[] getOnBinaryArgResolvers() {
        return this.onBinaryArgResolvers;
    }

    public MethodArgumentResolver[] getOnEventArgResolvers() {
        return this.onEventArgResolvers;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public AbstractBeanFactory getBeanFactory() {
        return this.beanFactory;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setHandlerClazz(Class<?> handlerClazz) {
        this.handlerClazz = handlerClazz;
    }

    public void setBeanObject(Object beanObject) {
        this.beanObject = beanObject;
    }

    public void setOnOpenMethod(Method onOpenMethod) {
        this.onOpenMethod = onOpenMethod;
    }

    public void setOnMessageMethod(Method onMessageMethod) {
        this.onMessageMethod = onMessageMethod;
    }

    public void setOnCloseMethod(Method onCloseMethod) {
        this.onCloseMethod = onCloseMethod;
    }

    public void setBeforeHandshake(Method beforeHandshake) {
        this.beforeHandshake = beforeHandshake;
    }

    public void setOnErrorMethod(Method onErrorMethod) {
        this.onErrorMethod = onErrorMethod;
    }

    public void setOnBinaryMethod(Method onBinaryMethod) {
        this.onBinaryMethod = onBinaryMethod;
    }

    public void setOnEventMethod(Method onEventMethod) {
        this.onEventMethod = onEventMethod;
    }

    public void setBeforeHandshakeParameters(MethodParameter[] beforeHandshakeParameters) {
        this.beforeHandshakeParameters = beforeHandshakeParameters;
    }

    public void setOnOpenParameters(MethodParameter[] onOpenParameters) {
        this.onOpenParameters = onOpenParameters;
    }

    public void setOnCloseParameters(MethodParameter[] onCloseParameters) {
        this.onCloseParameters = onCloseParameters;
    }

    public void setOnErrorParameters(MethodParameter[] onErrorParameters) {
        this.onErrorParameters = onErrorParameters;
    }

    public void setOnMessageParameters(MethodParameter[] onMessageParameters) {
        this.onMessageParameters = onMessageParameters;
    }

    public void setOnBinaryParameters(MethodParameter[] onBinaryParameters) {
        this.onBinaryParameters = onBinaryParameters;
    }

    public void setOnEventParameters(MethodParameter[] onEventParameters) {
        this.onEventParameters = onEventParameters;
    }

    public void setBeforeHandshakeArgResolvers(MethodArgumentResolver[] beforeHandshakeArgResolvers) {
        this.beforeHandshakeArgResolvers = beforeHandshakeArgResolvers;
    }

    public void setOnOpenArgResolvers(MethodArgumentResolver[] onOpenArgResolvers) {
        this.onOpenArgResolvers = onOpenArgResolvers;
    }

    public void setOnCloseArgResolvers(MethodArgumentResolver[] onCloseArgResolvers) {
        this.onCloseArgResolvers = onCloseArgResolvers;
    }

    public void setOnErrorArgResolvers(MethodArgumentResolver[] onErrorArgResolvers) {
        this.onErrorArgResolvers = onErrorArgResolvers;
    }

    public void setOnMessageArgResolvers(MethodArgumentResolver[] onMessageArgResolvers) {
        this.onMessageArgResolvers = onMessageArgResolvers;
    }

    public void setOnBinaryArgResolvers(MethodArgumentResolver[] onBinaryArgResolvers) {
        this.onBinaryArgResolvers = onBinaryArgResolvers;
    }

    public void setOnEventArgResolvers(MethodArgumentResolver[] onEventArgResolvers) {
        this.onEventArgResolvers = onEventArgResolvers;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setBeanFactory(AbstractBeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WebsocketMethodMapping)) {
            return false;
        }
        WebsocketMethodMapping other = (WebsocketMethodMapping)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        Class<?> this$handlerClazz = this.getHandlerClazz();
        Class<?> other$handlerClazz = other.getHandlerClazz();
        if (this$handlerClazz == null ? other$handlerClazz != null : !this$handlerClazz.equals(other$handlerClazz)) {
            return false;
        }
        Object this$beanObject = this.getBeanObject();
        Object other$beanObject = other.getBeanObject();
        if (this$beanObject == null ? other$beanObject != null : !this$beanObject.equals(other$beanObject)) {
            return false;
        }
        Method this$onOpenMethod = this.getOnOpenMethod();
        Method other$onOpenMethod = other.getOnOpenMethod();
        if (this$onOpenMethod == null ? other$onOpenMethod != null : !((Object)this$onOpenMethod).equals(other$onOpenMethod)) {
            return false;
        }
        Method this$onMessageMethod = this.getOnMessageMethod();
        Method other$onMessageMethod = other.getOnMessageMethod();
        if (this$onMessageMethod == null ? other$onMessageMethod != null : !((Object)this$onMessageMethod).equals(other$onMessageMethod)) {
            return false;
        }
        Method this$onCloseMethod = this.getOnCloseMethod();
        Method other$onCloseMethod = other.getOnCloseMethod();
        if (this$onCloseMethod == null ? other$onCloseMethod != null : !((Object)this$onCloseMethod).equals(other$onCloseMethod)) {
            return false;
        }
        Method this$beforeHandshake = this.getBeforeHandshake();
        Method other$beforeHandshake = other.getBeforeHandshake();
        if (this$beforeHandshake == null ? other$beforeHandshake != null : !((Object)this$beforeHandshake).equals(other$beforeHandshake)) {
            return false;
        }
        Method this$onErrorMethod = this.getOnErrorMethod();
        Method other$onErrorMethod = other.getOnErrorMethod();
        if (this$onErrorMethod == null ? other$onErrorMethod != null : !((Object)this$onErrorMethod).equals(other$onErrorMethod)) {
            return false;
        }
        Method this$onBinaryMethod = this.getOnBinaryMethod();
        Method other$onBinaryMethod = other.getOnBinaryMethod();
        if (this$onBinaryMethod == null ? other$onBinaryMethod != null : !((Object)this$onBinaryMethod).equals(other$onBinaryMethod)) {
            return false;
        }
        Method this$onEventMethod = this.getOnEventMethod();
        Method other$onEventMethod = other.getOnEventMethod();
        if (this$onEventMethod == null ? other$onEventMethod != null : !((Object)this$onEventMethod).equals(other$onEventMethod)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getBeforeHandshakeParameters(), other.getBeforeHandshakeParameters())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getOnOpenParameters(), other.getOnOpenParameters())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getOnCloseParameters(), other.getOnCloseParameters())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getOnErrorParameters(), other.getOnErrorParameters())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getOnMessageParameters(), other.getOnMessageParameters())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getOnBinaryParameters(), other.getOnBinaryParameters())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getOnEventParameters(), other.getOnEventParameters())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getBeforeHandshakeArgResolvers(), other.getBeforeHandshakeArgResolvers())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getOnOpenArgResolvers(), other.getOnOpenArgResolvers())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getOnCloseArgResolvers(), other.getOnCloseArgResolvers())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getOnErrorArgResolvers(), other.getOnErrorArgResolvers())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getOnMessageArgResolvers(), other.getOnMessageArgResolvers())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getOnBinaryArgResolvers(), other.getOnBinaryArgResolvers())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getOnEventArgResolvers(), other.getOnEventArgResolvers())) {
            return false;
        }
        ApplicationContext this$applicationContext = this.getApplicationContext();
        ApplicationContext other$applicationContext = other.getApplicationContext();
        if (this$applicationContext == null ? other$applicationContext != null : !this$applicationContext.equals(other$applicationContext)) {
            return false;
        }
        AbstractBeanFactory this$beanFactory = this.getBeanFactory();
        AbstractBeanFactory other$beanFactory = other.getBeanFactory();
        return !(this$beanFactory == null ? other$beanFactory != null : !this$beanFactory.equals(other$beanFactory));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WebsocketMethodMapping;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        Class<?> $handlerClazz = this.getHandlerClazz();
        result = result * 59 + ($handlerClazz == null ? 43 : $handlerClazz.hashCode());
        Object $beanObject = this.getBeanObject();
        result = result * 59 + ($beanObject == null ? 43 : $beanObject.hashCode());
        Method $onOpenMethod = this.getOnOpenMethod();
        result = result * 59 + ($onOpenMethod == null ? 43 : ((Object)$onOpenMethod).hashCode());
        Method $onMessageMethod = this.getOnMessageMethod();
        result = result * 59 + ($onMessageMethod == null ? 43 : ((Object)$onMessageMethod).hashCode());
        Method $onCloseMethod = this.getOnCloseMethod();
        result = result * 59 + ($onCloseMethod == null ? 43 : ((Object)$onCloseMethod).hashCode());
        Method $beforeHandshake = this.getBeforeHandshake();
        result = result * 59 + ($beforeHandshake == null ? 43 : ((Object)$beforeHandshake).hashCode());
        Method $onErrorMethod = this.getOnErrorMethod();
        result = result * 59 + ($onErrorMethod == null ? 43 : ((Object)$onErrorMethod).hashCode());
        Method $onBinaryMethod = this.getOnBinaryMethod();
        result = result * 59 + ($onBinaryMethod == null ? 43 : ((Object)$onBinaryMethod).hashCode());
        Method $onEventMethod = this.getOnEventMethod();
        result = result * 59 + ($onEventMethod == null ? 43 : ((Object)$onEventMethod).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getBeforeHandshakeParameters());
        result = result * 59 + Arrays.deepHashCode(this.getOnOpenParameters());
        result = result * 59 + Arrays.deepHashCode(this.getOnCloseParameters());
        result = result * 59 + Arrays.deepHashCode(this.getOnErrorParameters());
        result = result * 59 + Arrays.deepHashCode(this.getOnMessageParameters());
        result = result * 59 + Arrays.deepHashCode(this.getOnBinaryParameters());
        result = result * 59 + Arrays.deepHashCode(this.getOnEventParameters());
        result = result * 59 + Arrays.deepHashCode(this.getBeforeHandshakeArgResolvers());
        result = result * 59 + Arrays.deepHashCode(this.getOnOpenArgResolvers());
        result = result * 59 + Arrays.deepHashCode(this.getOnCloseArgResolvers());
        result = result * 59 + Arrays.deepHashCode(this.getOnErrorArgResolvers());
        result = result * 59 + Arrays.deepHashCode(this.getOnMessageArgResolvers());
        result = result * 59 + Arrays.deepHashCode(this.getOnBinaryArgResolvers());
        result = result * 59 + Arrays.deepHashCode(this.getOnEventArgResolvers());
        ApplicationContext $applicationContext = this.getApplicationContext();
        result = result * 59 + ($applicationContext == null ? 43 : $applicationContext.hashCode());
        AbstractBeanFactory $beanFactory = this.getBeanFactory();
        result = result * 59 + ($beanFactory == null ? 43 : $beanFactory.hashCode());
        return result;
    }

    public String toString() {
        return "WebsocketMethodMapping(path=" + this.getPath() + ", handlerClazz=" + this.getHandlerClazz() + ", beanObject=" + this.getBeanObject() + ", onOpenMethod=" + this.getOnOpenMethod() + ", onMessageMethod=" + this.getOnMessageMethod() + ", onCloseMethod=" + this.getOnCloseMethod() + ", beforeHandshake=" + this.getBeforeHandshake() + ", onErrorMethod=" + this.getOnErrorMethod() + ", onBinaryMethod=" + this.getOnBinaryMethod() + ", onEventMethod=" + this.getOnEventMethod() + ", beforeHandshakeParameters=" + Arrays.deepToString(this.getBeforeHandshakeParameters()) + ", onOpenParameters=" + Arrays.deepToString(this.getOnOpenParameters()) + ", onCloseParameters=" + Arrays.deepToString(this.getOnCloseParameters()) + ", onErrorParameters=" + Arrays.deepToString(this.getOnErrorParameters()) + ", onMessageParameters=" + Arrays.deepToString(this.getOnMessageParameters()) + ", onBinaryParameters=" + Arrays.deepToString(this.getOnBinaryParameters()) + ", onEventParameters=" + Arrays.deepToString(this.getOnEventParameters()) + ", beforeHandshakeArgResolvers=" + Arrays.deepToString(this.getBeforeHandshakeArgResolvers()) + ", onOpenArgResolvers=" + Arrays.deepToString(this.getOnOpenArgResolvers()) + ", onCloseArgResolvers=" + Arrays.deepToString(this.getOnCloseArgResolvers()) + ", onErrorArgResolvers=" + Arrays.deepToString(this.getOnErrorArgResolvers()) + ", onMessageArgResolvers=" + Arrays.deepToString(this.getOnMessageArgResolvers()) + ", onBinaryArgResolvers=" + Arrays.deepToString(this.getOnBinaryArgResolvers()) + ", onEventArgResolvers=" + Arrays.deepToString(this.getOnEventArgResolvers()) + ", applicationContext=" + this.getApplicationContext() + ", beanFactory=" + this.getBeanFactory() + ")";
    }
}

