/*
 * Decompiled with CFR 0.152.
 */
package plus.jdk.websocket.properties;

import io.netty.handler.logging.LogLevel;
import java.util.Arrays;
import org.springframework.boot.context.properties.ConfigurationProperties;
import plus.jdk.websocket.global.DefaultSessionAuthenticatorManager;
import plus.jdk.websocket.global.IWSSessionAuthenticatorManager;
import plus.jdk.websocket.model.IWsSession;

@ConfigurationProperties(prefix="plus.jdk.websocket")
public class WebsocketProperties {
    private Boolean enabled = false;
    private Integer bossLoopGroupThreads = 0;
    private Integer workerLoopGroupThreads = 0;
    private String[] corsOrigins;
    private Boolean corsAllowCredentials = false;
    private Integer port = 10300;
    private String host = "";
    private Boolean useEventExecutorGroup = true;
    private Integer eventExecutorGroupThreads = 0;
    private Integer connectTimeoutMillis;
    private Integer SO_BACKLOG;
    private Integer writeSpinCount;
    private LogLevel logLevel = LogLevel.DEBUG;
    private Integer readerIdleTimeSeconds = 0;
    private Integer writerIdleTimeSeconds = 0;
    private Integer allIdleTimeSeconds = 0;
    private Integer maxFramePayloadLength = 65536;
    private Boolean useCompressionHandler = false;
    private Integer childOptionSoRcvBuf = -1;
    private Integer childOptionSoSndBuf = -1;
    private Integer broadcastMonitorPort = 10300;
    private Boolean printBroadcastMessage = true;
    private Class<? extends IWSSessionAuthenticatorManager<?, ? extends IWsSession<?>>> sessionAuthenticator = DefaultSessionAuthenticatorManager.class;

    public Boolean getEnabled() {
        return this.enabled;
    }

    public Integer getBossLoopGroupThreads() {
        return this.bossLoopGroupThreads;
    }

    public Integer getWorkerLoopGroupThreads() {
        return this.workerLoopGroupThreads;
    }

    public String[] getCorsOrigins() {
        return this.corsOrigins;
    }

    public Boolean getCorsAllowCredentials() {
        return this.corsAllowCredentials;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getHost() {
        return this.host;
    }

    public Boolean getUseEventExecutorGroup() {
        return this.useEventExecutorGroup;
    }

    public Integer getEventExecutorGroupThreads() {
        return this.eventExecutorGroupThreads;
    }

    public Integer getConnectTimeoutMillis() {
        return this.connectTimeoutMillis;
    }

    public Integer getSO_BACKLOG() {
        return this.SO_BACKLOG;
    }

    public Integer getWriteSpinCount() {
        return this.writeSpinCount;
    }

    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    public Integer getReaderIdleTimeSeconds() {
        return this.readerIdleTimeSeconds;
    }

    public Integer getWriterIdleTimeSeconds() {
        return this.writerIdleTimeSeconds;
    }

    public Integer getAllIdleTimeSeconds() {
        return this.allIdleTimeSeconds;
    }

    public Integer getMaxFramePayloadLength() {
        return this.maxFramePayloadLength;
    }

    public Boolean getUseCompressionHandler() {
        return this.useCompressionHandler;
    }

    public Integer getChildOptionSoRcvBuf() {
        return this.childOptionSoRcvBuf;
    }

    public Integer getChildOptionSoSndBuf() {
        return this.childOptionSoSndBuf;
    }

    public Integer getBroadcastMonitorPort() {
        return this.broadcastMonitorPort;
    }

    public Boolean getPrintBroadcastMessage() {
        return this.printBroadcastMessage;
    }

    public Class<? extends IWSSessionAuthenticatorManager<?, ? extends IWsSession<?>>> getSessionAuthenticator() {
        return this.sessionAuthenticator;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public void setBossLoopGroupThreads(Integer bossLoopGroupThreads) {
        this.bossLoopGroupThreads = bossLoopGroupThreads;
    }

    public void setWorkerLoopGroupThreads(Integer workerLoopGroupThreads) {
        this.workerLoopGroupThreads = workerLoopGroupThreads;
    }

    public void setCorsOrigins(String[] corsOrigins) {
        this.corsOrigins = corsOrigins;
    }

    public void setCorsAllowCredentials(Boolean corsAllowCredentials) {
        this.corsAllowCredentials = corsAllowCredentials;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setUseEventExecutorGroup(Boolean useEventExecutorGroup) {
        this.useEventExecutorGroup = useEventExecutorGroup;
    }

    public void setEventExecutorGroupThreads(Integer eventExecutorGroupThreads) {
        this.eventExecutorGroupThreads = eventExecutorGroupThreads;
    }

    public void setConnectTimeoutMillis(Integer connectTimeoutMillis) {
        this.connectTimeoutMillis = connectTimeoutMillis;
    }

    public void setSO_BACKLOG(Integer SO_BACKLOG) {
        this.SO_BACKLOG = SO_BACKLOG;
    }

    public void setWriteSpinCount(Integer writeSpinCount) {
        this.writeSpinCount = writeSpinCount;
    }

    public void setLogLevel(LogLevel logLevel) {
        this.logLevel = logLevel;
    }

    public void setReaderIdleTimeSeconds(Integer readerIdleTimeSeconds) {
        this.readerIdleTimeSeconds = readerIdleTimeSeconds;
    }

    public void setWriterIdleTimeSeconds(Integer writerIdleTimeSeconds) {
        this.writerIdleTimeSeconds = writerIdleTimeSeconds;
    }

    public void setAllIdleTimeSeconds(Integer allIdleTimeSeconds) {
        this.allIdleTimeSeconds = allIdleTimeSeconds;
    }

    public void setMaxFramePayloadLength(Integer maxFramePayloadLength) {
        this.maxFramePayloadLength = maxFramePayloadLength;
    }

    public void setUseCompressionHandler(Boolean useCompressionHandler) {
        this.useCompressionHandler = useCompressionHandler;
    }

    public void setChildOptionSoRcvBuf(Integer childOptionSoRcvBuf) {
        this.childOptionSoRcvBuf = childOptionSoRcvBuf;
    }

    public void setChildOptionSoSndBuf(Integer childOptionSoSndBuf) {
        this.childOptionSoSndBuf = childOptionSoSndBuf;
    }

    public void setBroadcastMonitorPort(Integer broadcastMonitorPort) {
        this.broadcastMonitorPort = broadcastMonitorPort;
    }

    public void setPrintBroadcastMessage(Boolean printBroadcastMessage) {
        this.printBroadcastMessage = printBroadcastMessage;
    }

    public void setSessionAuthenticator(Class<? extends IWSSessionAuthenticatorManager<?, ? extends IWsSession<?>>> sessionAuthenticator) {
        this.sessionAuthenticator = sessionAuthenticator;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WebsocketProperties)) {
            return false;
        }
        WebsocketProperties other = (WebsocketProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$enabled = this.getEnabled();
        Boolean other$enabled = other.getEnabled();
        if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
            return false;
        }
        Integer this$bossLoopGroupThreads = this.getBossLoopGroupThreads();
        Integer other$bossLoopGroupThreads = other.getBossLoopGroupThreads();
        if (this$bossLoopGroupThreads == null ? other$bossLoopGroupThreads != null : !((Object)this$bossLoopGroupThreads).equals(other$bossLoopGroupThreads)) {
            return false;
        }
        Integer this$workerLoopGroupThreads = this.getWorkerLoopGroupThreads();
        Integer other$workerLoopGroupThreads = other.getWorkerLoopGroupThreads();
        if (this$workerLoopGroupThreads == null ? other$workerLoopGroupThreads != null : !((Object)this$workerLoopGroupThreads).equals(other$workerLoopGroupThreads)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getCorsOrigins(), other.getCorsOrigins())) {
            return false;
        }
        Boolean this$corsAllowCredentials = this.getCorsAllowCredentials();
        Boolean other$corsAllowCredentials = other.getCorsAllowCredentials();
        if (this$corsAllowCredentials == null ? other$corsAllowCredentials != null : !((Object)this$corsAllowCredentials).equals(other$corsAllowCredentials)) {
            return false;
        }
        Integer this$port = this.getPort();
        Integer other$port = other.getPort();
        if (this$port == null ? other$port != null : !((Object)this$port).equals(other$port)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        Boolean this$useEventExecutorGroup = this.getUseEventExecutorGroup();
        Boolean other$useEventExecutorGroup = other.getUseEventExecutorGroup();
        if (this$useEventExecutorGroup == null ? other$useEventExecutorGroup != null : !((Object)this$useEventExecutorGroup).equals(other$useEventExecutorGroup)) {
            return false;
        }
        Integer this$eventExecutorGroupThreads = this.getEventExecutorGroupThreads();
        Integer other$eventExecutorGroupThreads = other.getEventExecutorGroupThreads();
        if (this$eventExecutorGroupThreads == null ? other$eventExecutorGroupThreads != null : !((Object)this$eventExecutorGroupThreads).equals(other$eventExecutorGroupThreads)) {
            return false;
        }
        Integer this$connectTimeoutMillis = this.getConnectTimeoutMillis();
        Integer other$connectTimeoutMillis = other.getConnectTimeoutMillis();
        if (this$connectTimeoutMillis == null ? other$connectTimeoutMillis != null : !((Object)this$connectTimeoutMillis).equals(other$connectTimeoutMillis)) {
            return false;
        }
        Integer this$SO_BACKLOG = this.getSO_BACKLOG();
        Integer other$SO_BACKLOG = other.getSO_BACKLOG();
        if (this$SO_BACKLOG == null ? other$SO_BACKLOG != null : !((Object)this$SO_BACKLOG).equals(other$SO_BACKLOG)) {
            return false;
        }
        Integer this$writeSpinCount = this.getWriteSpinCount();
        Integer other$writeSpinCount = other.getWriteSpinCount();
        if (this$writeSpinCount == null ? other$writeSpinCount != null : !((Object)this$writeSpinCount).equals(other$writeSpinCount)) {
            return false;
        }
        LogLevel this$logLevel = this.getLogLevel();
        LogLevel other$logLevel = other.getLogLevel();
        if (this$logLevel == null ? other$logLevel != null : !this$logLevel.equals(other$logLevel)) {
            return false;
        }
        Integer this$readerIdleTimeSeconds = this.getReaderIdleTimeSeconds();
        Integer other$readerIdleTimeSeconds = other.getReaderIdleTimeSeconds();
        if (this$readerIdleTimeSeconds == null ? other$readerIdleTimeSeconds != null : !((Object)this$readerIdleTimeSeconds).equals(other$readerIdleTimeSeconds)) {
            return false;
        }
        Integer this$writerIdleTimeSeconds = this.getWriterIdleTimeSeconds();
        Integer other$writerIdleTimeSeconds = other.getWriterIdleTimeSeconds();
        if (this$writerIdleTimeSeconds == null ? other$writerIdleTimeSeconds != null : !((Object)this$writerIdleTimeSeconds).equals(other$writerIdleTimeSeconds)) {
            return false;
        }
        Integer this$allIdleTimeSeconds = this.getAllIdleTimeSeconds();
        Integer other$allIdleTimeSeconds = other.getAllIdleTimeSeconds();
        if (this$allIdleTimeSeconds == null ? other$allIdleTimeSeconds != null : !((Object)this$allIdleTimeSeconds).equals(other$allIdleTimeSeconds)) {
            return false;
        }
        Integer this$maxFramePayloadLength = this.getMaxFramePayloadLength();
        Integer other$maxFramePayloadLength = other.getMaxFramePayloadLength();
        if (this$maxFramePayloadLength == null ? other$maxFramePayloadLength != null : !((Object)this$maxFramePayloadLength).equals(other$maxFramePayloadLength)) {
            return false;
        }
        Boolean this$useCompressionHandler = this.getUseCompressionHandler();
        Boolean other$useCompressionHandler = other.getUseCompressionHandler();
        if (this$useCompressionHandler == null ? other$useCompressionHandler != null : !((Object)this$useCompressionHandler).equals(other$useCompressionHandler)) {
            return false;
        }
        Integer this$childOptionSoRcvBuf = this.getChildOptionSoRcvBuf();
        Integer other$childOptionSoRcvBuf = other.getChildOptionSoRcvBuf();
        if (this$childOptionSoRcvBuf == null ? other$childOptionSoRcvBuf != null : !((Object)this$childOptionSoRcvBuf).equals(other$childOptionSoRcvBuf)) {
            return false;
        }
        Integer this$childOptionSoSndBuf = this.getChildOptionSoSndBuf();
        Integer other$childOptionSoSndBuf = other.getChildOptionSoSndBuf();
        if (this$childOptionSoSndBuf == null ? other$childOptionSoSndBuf != null : !((Object)this$childOptionSoSndBuf).equals(other$childOptionSoSndBuf)) {
            return false;
        }
        Integer this$broadcastMonitorPort = this.getBroadcastMonitorPort();
        Integer other$broadcastMonitorPort = other.getBroadcastMonitorPort();
        if (this$broadcastMonitorPort == null ? other$broadcastMonitorPort != null : !((Object)this$broadcastMonitorPort).equals(other$broadcastMonitorPort)) {
            return false;
        }
        Boolean this$printBroadcastMessage = this.getPrintBroadcastMessage();
        Boolean other$printBroadcastMessage = other.getPrintBroadcastMessage();
        if (this$printBroadcastMessage == null ? other$printBroadcastMessage != null : !((Object)this$printBroadcastMessage).equals(other$printBroadcastMessage)) {
            return false;
        }
        Class<IWSSessionAuthenticatorManager<?, IWsSession<?>>> this$sessionAuthenticator = this.getSessionAuthenticator();
        Class<? extends IWSSessionAuthenticatorManager<?, ? extends IWsSession<?>>> other$sessionAuthenticator = other.getSessionAuthenticator();
        return !(this$sessionAuthenticator == null ? other$sessionAuthenticator != null : !this$sessionAuthenticator.equals(other$sessionAuthenticator));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WebsocketProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $enabled = this.getEnabled();
        result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
        Integer $bossLoopGroupThreads = this.getBossLoopGroupThreads();
        result = result * 59 + ($bossLoopGroupThreads == null ? 43 : ((Object)$bossLoopGroupThreads).hashCode());
        Integer $workerLoopGroupThreads = this.getWorkerLoopGroupThreads();
        result = result * 59 + ($workerLoopGroupThreads == null ? 43 : ((Object)$workerLoopGroupThreads).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getCorsOrigins());
        Boolean $corsAllowCredentials = this.getCorsAllowCredentials();
        result = result * 59 + ($corsAllowCredentials == null ? 43 : ((Object)$corsAllowCredentials).hashCode());
        Integer $port = this.getPort();
        result = result * 59 + ($port == null ? 43 : ((Object)$port).hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        Boolean $useEventExecutorGroup = this.getUseEventExecutorGroup();
        result = result * 59 + ($useEventExecutorGroup == null ? 43 : ((Object)$useEventExecutorGroup).hashCode());
        Integer $eventExecutorGroupThreads = this.getEventExecutorGroupThreads();
        result = result * 59 + ($eventExecutorGroupThreads == null ? 43 : ((Object)$eventExecutorGroupThreads).hashCode());
        Integer $connectTimeoutMillis = this.getConnectTimeoutMillis();
        result = result * 59 + ($connectTimeoutMillis == null ? 43 : ((Object)$connectTimeoutMillis).hashCode());
        Integer $SO_BACKLOG = this.getSO_BACKLOG();
        result = result * 59 + ($SO_BACKLOG == null ? 43 : ((Object)$SO_BACKLOG).hashCode());
        Integer $writeSpinCount = this.getWriteSpinCount();
        result = result * 59 + ($writeSpinCount == null ? 43 : ((Object)$writeSpinCount).hashCode());
        LogLevel $logLevel = this.getLogLevel();
        result = result * 59 + ($logLevel == null ? 43 : $logLevel.hashCode());
        Integer $readerIdleTimeSeconds = this.getReaderIdleTimeSeconds();
        result = result * 59 + ($readerIdleTimeSeconds == null ? 43 : ((Object)$readerIdleTimeSeconds).hashCode());
        Integer $writerIdleTimeSeconds = this.getWriterIdleTimeSeconds();
        result = result * 59 + ($writerIdleTimeSeconds == null ? 43 : ((Object)$writerIdleTimeSeconds).hashCode());
        Integer $allIdleTimeSeconds = this.getAllIdleTimeSeconds();
        result = result * 59 + ($allIdleTimeSeconds == null ? 43 : ((Object)$allIdleTimeSeconds).hashCode());
        Integer $maxFramePayloadLength = this.getMaxFramePayloadLength();
        result = result * 59 + ($maxFramePayloadLength == null ? 43 : ((Object)$maxFramePayloadLength).hashCode());
        Boolean $useCompressionHandler = this.getUseCompressionHandler();
        result = result * 59 + ($useCompressionHandler == null ? 43 : ((Object)$useCompressionHandler).hashCode());
        Integer $childOptionSoRcvBuf = this.getChildOptionSoRcvBuf();
        result = result * 59 + ($childOptionSoRcvBuf == null ? 43 : ((Object)$childOptionSoRcvBuf).hashCode());
        Integer $childOptionSoSndBuf = this.getChildOptionSoSndBuf();
        result = result * 59 + ($childOptionSoSndBuf == null ? 43 : ((Object)$childOptionSoSndBuf).hashCode());
        Integer $broadcastMonitorPort = this.getBroadcastMonitorPort();
        result = result * 59 + ($broadcastMonitorPort == null ? 43 : ((Object)$broadcastMonitorPort).hashCode());
        Boolean $printBroadcastMessage = this.getPrintBroadcastMessage();
        result = result * 59 + ($printBroadcastMessage == null ? 43 : ((Object)$printBroadcastMessage).hashCode());
        Class<IWSSessionAuthenticatorManager<?, IWsSession<?>>> $sessionAuthenticator = this.getSessionAuthenticator();
        result = result * 59 + ($sessionAuthenticator == null ? 43 : $sessionAuthenticator.hashCode());
        return result;
    }

    public String toString() {
        return "WebsocketProperties(enabled=" + this.getEnabled() + ", bossLoopGroupThreads=" + this.getBossLoopGroupThreads() + ", workerLoopGroupThreads=" + this.getWorkerLoopGroupThreads() + ", corsOrigins=" + Arrays.deepToString(this.getCorsOrigins()) + ", corsAllowCredentials=" + this.getCorsAllowCredentials() + ", port=" + this.getPort() + ", host=" + this.getHost() + ", useEventExecutorGroup=" + this.getUseEventExecutorGroup() + ", eventExecutorGroupThreads=" + this.getEventExecutorGroupThreads() + ", connectTimeoutMillis=" + this.getConnectTimeoutMillis() + ", SO_BACKLOG=" + this.getSO_BACKLOG() + ", writeSpinCount=" + this.getWriteSpinCount() + ", logLevel=" + this.getLogLevel() + ", readerIdleTimeSeconds=" + this.getReaderIdleTimeSeconds() + ", writerIdleTimeSeconds=" + this.getWriterIdleTimeSeconds() + ", allIdleTimeSeconds=" + this.getAllIdleTimeSeconds() + ", maxFramePayloadLength=" + this.getMaxFramePayloadLength() + ", useCompressionHandler=" + this.getUseCompressionHandler() + ", childOptionSoRcvBuf=" + this.getChildOptionSoRcvBuf() + ", childOptionSoSndBuf=" + this.getChildOptionSoSndBuf() + ", broadcastMonitorPort=" + this.getBroadcastMonitorPort() + ", printBroadcastMessage=" + this.getPrintBroadcastMessage() + ", sessionAuthenticator=" + this.getSessionAuthenticator() + ")";
    }
}

