/*
 * Decompiled with CFR 0.152.
 */
package pro.cryptoevil.proxy.integrations.getproxylist;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.beans.ConstructorProperties;
import java.util.Collections;
import pro.cryptoevil.proxy.core.ProxyRepository;
import pro.cryptoevil.proxy.impl.model.Proxy;
import pro.cryptoevil.proxy.web.WebClient;

public class GetProxyListProxyRepository
implements ProxyRepository<Proxy> {
    private String endpointUrl;
    private String apiKey;
    private ObjectMapper objectMapper;
    private WebClient webClient;

    @Override
    public Proxy get() {
        String url = this.endpointUrl.concat(this.apiKey);
        String response = this.webClient.getResponseBody(url, Collections.emptyMap());
        try {
            return (Proxy)this.objectMapper.readValue(response, Proxy.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @ConstructorProperties(value={"endpointUrl", "apiKey", "objectMapper", "webClient"})
    public GetProxyListProxyRepository(String endpointUrl, String apiKey, ObjectMapper objectMapper, WebClient webClient) {
        this.endpointUrl = endpointUrl;
        this.apiKey = apiKey;
        this.objectMapper = objectMapper;
        this.webClient = webClient;
    }
}

