/*
 * Decompiled with CFR 0.152.
 */
package pub.carzy.export_file.file_export.actuator.convertor_impl;

import pub.carzy.export_file.file_export.actuator.ExportFileValueConvertor;
import pub.carzy.export_file.file_export.entity.ExportValueFormat;
import pub.carzy.export_file.util.ObjectUtils;

public class ArrayToStringExportFileValueConvertor
implements ExportFileValueConvertor {
    @Override
    public boolean match(ExportValueFormat convertor) {
        return convertor.getType() == 5;
    }

    @Override
    public Object formatValue(ExportValueFormat convertor, Object value) {
        if (value instanceof String) {
            String[] split;
            StringBuilder builder = new StringBuilder();
            String reg = convertor.getValue();
            String placeholder = convertor.getExtMap().get("placeholder");
            String separator = convertor.getExtMap().get("separator");
            for (String line : split = ((String)value).split(ObjectUtils.isEmpty(reg) ? "" : reg)) {
                builder.append(placeholder == null ? line : line.replace(placeholder, reg));
                if (separator != null) {
                    builder.append(separator);
                    continue;
                }
                builder.append("\n");
            }
            if (separator != null && builder.length() > separator.length()) {
                int length = separator.length();
                CharSequence subSequence = builder.subSequence(builder.length() - length - 1, builder.length());
                if (subSequence.equals(separator)) {
                    return builder.substring(builder.length() - length - 1);
                }
            } else {
                if (builder.length() <= 0) {
                    return builder.toString();
                }
                return builder.charAt(builder.length() - 1) == '\n' ? builder.substring(0, builder.length() - 1) : builder.toString();
            }
        }
        return value;
    }
}

