/*
 * Decompiled with CFR 0.152.
 */
package pub.carzy.export_file.file_export.actuator.convertor_impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import pub.carzy.export_file.file_export.actuator.ExportFileValueConvertor;
import pub.carzy.export_file.file_export.entity.ExportValueFormat;

public class BitwiseOperationConvertor
implements ExportFileValueConvertor {
    public static final String[] OPTS = new String[]{"&", "|", "^", "~", "<<", ">>", ">>>"};

    @Override
    public boolean match(ExportValueFormat convertor) {
        return convertor.getType() == 7;
    }

    @Override
    public Object formatValue(ExportValueFormat convertor, Object value) {
        if (!(value instanceof Number)) {
            return value;
        }
        long v = ((Integer)value).intValue();
        Map<String, String> extMap = convertor.getExtMap();
        Map<String, String> valueMap = convertor.getValueMap();
        String operation = extMap.get("operation");
        if (!this.checkOperation(operation)) {
            return value;
        }
        ArrayList<String> arr = new ArrayList<String>();
        boolean skip = false;
        block26: for (Map.Entry<String, String> line : valueMap.entrySet()) {
            String key = line.getKey();
            try {
                long k = Integer.parseInt(key);
                block8 : switch (operation) {
                    case "&": {
                        if ((v & k) != k) continue block26;
                        arr.add(line.getValue());
                        break;
                    }
                    case "|": {
                        if ((v | k) != k) continue block26;
                        arr.add(line.getValue());
                        break;
                    }
                    case "^": {
                        if ((v ^ k) != k) continue block26;
                        arr.add(line.getValue());
                        break;
                    }
                    case "~": {
                        if ((v ^ 0xFFFFFFFFFFFFFFFFL) != k) continue block26;
                        arr.add(line.getValue());
                        break;
                    }
                    default: {
                        if (!"<<".equals(operation) && !">>".equals(operation) && !">>>".equals(operation)) continue block26;
                        int count = 1;
                        try {
                            count = extMap.get("count") == null ? count : Integer.parseInt(extMap.get("count"));
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        if (count > 0) {
                            count = Math.min(count, 64);
                            switch (operation) {
                                case "<<": {
                                    if (v << count != k) break;
                                    arr.add(line.getValue());
                                    break block8;
                                }
                                case ">>": {
                                    if (v >> count != k) break;
                                    arr.add(line.getValue());
                                    break block8;
                                }
                                case ">>>": {
                                    if (v >>> count != k) break;
                                    arr.add(line.getValue());
                                    break block8;
                                }
                            }
                            break;
                        }
                        skip = true;
                        break block26;
                    }
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return skip ? value : arr.stream().collect(Collectors.joining(extMap.get("join") == null ? "" : (CharSequence)extMap.get("join")));
    }

    private boolean checkOperation(String operation) {
        if (operation == null) {
            return false;
        }
        return Arrays.asList(OPTS).contains(operation);
    }
}

