/*
 * Decompiled with CFR 0.152.
 */
package pub.carzy.export_file.file_export.actuator.convertor_impl;

import java.text.SimpleDateFormat;
import java.util.Date;
import pub.carzy.export_file.file_export.actuator.ExportFileValueConvertor;
import pub.carzy.export_file.file_export.entity.ExportValueFormat;
import pub.carzy.export_file.util.ObjectUtils;

public class DateTimeExportFileValueConvertor
implements ExportFileValueConvertor {
    private static final String DEFAULT_PATTERN = "yyyy-MM-dd HH:mm:ss";
    private final SimpleDateFormat FORMATTER = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    @Override
    public boolean match(ExportValueFormat convertor) {
        return convertor.getType() == 2;
    }

    @Override
    public Object formatValue(ExportValueFormat convertor, Object value) {
        String pattern = convertor.getExtMap().get("pattern");
        if (pattern != null) {
            pattern = pattern.trim();
        }
        if (ObjectUtils.isBlank(pattern) || pattern.equals(DEFAULT_PATTERN)) {
            if (value instanceof Date) {
                return this.FORMATTER.format(value);
            }
        } else {
            SimpleDateFormat format = new SimpleDateFormat(pattern);
            if (value instanceof Date) {
                return format.format(value);
            }
        }
        return value;
    }
}

