/*
 * Decompiled with CFR 0.152.
 */
package pub.carzy.export_file.file_export.actuator.convertor_impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import java.util.Properties;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import pub.carzy.export_file.file_export.actuator.ExportFileValueConvertor;
import pub.carzy.export_file.file_export.entity.ExportValueFormat;
import pub.carzy.export_file.util.ObjectUtils;

public class JsonExportFileValueConvertor
implements ExportFileValueConvertor {
    @Override
    public boolean match(ExportValueFormat convertor) {
        return convertor.getType() == 6;
    }

    @Override
    public Object formatValue(ExportValueFormat convertor, Object value) {
        String type = convertor.getExtMap().get("type");
        if (value instanceof String && ObjectUtils.isNotBlank(value)) {
            if (ObjectUtils.isBlank(type) || "yaml".equalsIgnoreCase(type) || "yml".equalsIgnoreCase(type)) {
                try {
                    JSONObject jsonObject = JSON.parseObject((String)value.toString());
                    Map map = (Map)JSONObject.toJavaObject((JSON)jsonObject, Map.class);
                    DumperOptions options = new DumperOptions();
                    options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
                    return new Yaml(options).dump((Object)map);
                }
                catch (Exception e) {
                    return null;
                }
            }
            if ("properties".equalsIgnoreCase(type)) {
                try {
                    Properties properties = this.convertJsonToProperties(JSON.parseObject((String)value.toString()));
                    return properties.toString();
                }
                catch (Exception e) {
                    return null;
                }
            }
        }
        return value;
    }

    Properties convertJsonToProperties(JSONObject json) {
        Properties props = new Properties();
        for (String key : json.keySet()) {
            Object value = json.get((Object)key);
            if (value instanceof JSONObject) {
                Properties nestedProps = this.convertJsonToProperties((JSONObject)value);
                for (String nestedKey : nestedProps.stringPropertyNames()) {
                    String fullKey = key + "." + nestedKey;
                    props.setProperty(fullKey, nestedProps.getProperty(nestedKey));
                }
                continue;
            }
            if (value instanceof Object[]) {
                Object[] array = (Object[])value;
                for (int i = 0; i < array.length; ++i) {
                    if (array[i] instanceof JSONObject) {
                        Properties nestedProps = this.convertJsonToProperties((JSONObject)array[i]);
                        for (String nestedKey : nestedProps.stringPropertyNames()) {
                            String fullKey = key + "[" + i + "]." + nestedKey;
                            props.setProperty(fullKey, nestedProps.getProperty(nestedKey));
                        }
                        continue;
                    }
                    String fullKey = key + "[" + i + "]";
                    props.setProperty(fullKey, array[i].toString());
                }
                continue;
            }
            props.setProperty(key, value.toString());
        }
        return props;
    }
}

