/*
 * Decompiled with CFR 0.152.
 */
package pub.carzy.export_file.file_export.actuator.writers;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import pub.carzy.export_file.exce.SystemErrorException;
import pub.carzy.export_file.file_export.actuator.ExportActuatorParam;
import pub.carzy.export_file.file_export.actuator.writers.AbstractFileWriter;

public class ExcelFileWriter
extends AbstractFileWriter {
    private XSSFWorkbook xssfWorkbook;
    private XSSFSheet xssfSheet;
    private int rowIndex;

    public ExcelFileWriter(ExportActuatorParam param) {
        super(param);
    }

    @Override
    protected String getFilename() {
        return this.param.getPrefix() + (this.param.getParam().getFilename().endsWith(".xlsx") ? this.param.getParam().getFilename() : this.param.getParam().getFilename() + ".xlsx");
    }

    @Override
    public <T> void writeLine(List<T> line, Map<String, Object> configs) {
        XSSFRow row = this.xssfSheet.createRow(this.rowIndex++);
        for (int i = 0; i < line.size(); ++i) {
            T value = line.get(i);
            XSSFCell cell = row.createCell(i);
            if (value == null) {
                cell.setCellValue("");
                continue;
            }
            if (value instanceof Number) {
                cell.setCellValue(((Number)value).doubleValue());
            } else if (value instanceof String) {
                cell.setCellValue((String)value);
            } else if (value instanceof Date) {
                cell.setCellValue((Date)value);
            } else if (value instanceof Calendar) {
                cell.setCellValue((Calendar)value);
            } else if (value instanceof RichTextString) {
                cell.setCellValue((RichTextString)value);
            } else {
                cell.setCellValue(value.toString());
            }
            if (configs == null) continue;
            this.setCellStyle(cell, configs);
        }
    }

    private void setCellStyle(XSSFCell cell, Map<String, Object> configs) {
        XSSFCellStyle cellStyle = this.xssfWorkbook.createCellStyle();
        XSSFFont font = this.xssfWorkbook.createFont();
        for (Map.Entry<String, Object> config : configs.entrySet()) {
            if ("\u5bf9\u9f50\u65b9\u5f0f".equals(config.getKey())) {
                if (!(config.getValue() instanceof String)) continue;
                if ("\u5c45\u4e2d".equals(config.getValue())) {
                    cellStyle.setAlignment(HorizontalAlignment.CENTER);
                    continue;
                }
                if (!"\u5c45\u53f3".equals(config.getValue())) continue;
                cellStyle.setAlignment(HorizontalAlignment.RIGHT);
                continue;
            }
            if ("\u5b57\u4f53".equals(config.getKey())) {
                if (!(config.getValue() instanceof String)) continue;
                font.setFontName((String)config.getValue());
                continue;
            }
            if ("\u5b57\u4f53\u5927\u5c0f".equals(config.getKey())) {
                if (!(config.getValue() instanceof Number)) continue;
                font.setFontHeightInPoints(((Number)config.getValue()).shortValue());
                continue;
            }
            if ("\u7c97\u4f53".equals(config.getKey())) {
                font.setBold(true);
                continue;
            }
            if ("\u659c\u4f53".equals(config.getKey())) {
                font.setItalic(true);
                continue;
            }
            if ("\u5220\u9664\u7ebf".equals(config.getKey())) {
                font.setStrikeout(true);
                continue;
            }
            if (!"\u4e0b\u5212\u7ebf".equals(config.getKey()) || !(config.getValue() instanceof Number)) continue;
            font.setUnderline(((Number)config.getValue()).byteValue());
        }
        cellStyle.setFont((Font)font);
        cell.setCellStyle((CellStyle)cellStyle);
    }

    @Override
    public void flush() throws IOException {
        try (FileOutputStream stream = new FileOutputStream(this.file);){
            this.xssfWorkbook.write((OutputStream)stream);
            stream.flush();
        }
        catch (IOException e) {
            throw new SystemErrorException();
        }
    }

    @Override
    protected void createdFile() throws IOException {
        super.createdFile();
        this.xssfWorkbook = new XSSFWorkbook();
        this.xssfSheet = this.xssfWorkbook.createSheet();
    }

    @Override
    public void close() throws IOException {
        if (this.xssfWorkbook != null) {
            this.flush();
            try {
                this.xssfWorkbook.close();
            }
            catch (IOException e) {
                throw new SystemErrorException();
            }
        }
    }
}

