/*
 * Decompiled with CFR 0.152.
 */
package pub.carzy.export_file.file_export.actuator.writers;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import pub.carzy.export_file.file_export.actuator.ExportActuatorParam;
import pub.carzy.export_file.file_export.actuator.writers.AbstractFileWriter;

public class TxtFileWriter
extends AbstractFileWriter {
    private PrintWriter writer;

    public TxtFileWriter(ExportActuatorParam param) {
        super(param);
    }

    @Override
    protected String getFilename() {
        return this.param.getPrefix() + (this.param.getParam().getFilename().endsWith(".txt") ? this.param.getParam().getFilename() : this.param.getParam().getFilename() + ".txt");
    }

    @Override
    protected void createdFile() throws IOException {
        super.createdFile();
        this.writer = new PrintWriter(this.file);
    }

    @Override
    public <T> void writeLine(List<T> line, Map<String, Object> configs) {
        for (int i = 0; i < line.size(); ++i) {
            T value = line.get(i);
            this.writer.print(value.toString());
            if (i >= line.size() - 1) continue;
            this.writer.print('\t');
        }
        this.writer.print('\n');
    }

    @Override
    public void flush() throws IOException {
        this.writer.flush();
    }

    @Override
    public void close() throws IOException {
        if (this.writer != null) {
            this.writer.flush();
            this.writer.close();
        }
    }
}

