/*
 * Decompiled with CFR 0.152.
 */
package pub.carzy.export_file.file_export.suppers;

import java.io.IOException;
import java.util.List;
import javax.annotation.Resource;
import org.aspectj.lang.ProceedingJoinPoint;
import pub.carzy.export_file.exce.SystemErrorException;
import pub.carzy.export_file.file_export.ExportFiler;
import pub.carzy.export_file.file_export.actuator.ExportActuator;
import pub.carzy.export_file.file_export.actuator.ExportActuatorConfig;
import pub.carzy.export_file.file_export.actuator.ExportActuatorParam;
import pub.carzy.export_file.file_export.entity.ExportRequestParam;
import pub.carzy.export_file.file_export.entity.ExportTitle;
import pub.carzy.export_file.spring_bean.WebEnvConfig;
import pub.carzy.export_file.template.ExportConvertorMerger;

public abstract class AbstractExportFiler
implements ExportFiler {
    @Resource
    private WebEnvConfig webEnvConfig;
    @Resource
    private ExportConvertorMerger merger;

    @Override
    public boolean match(ExportRequestParam param, Object data) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object export(ExportRequestParam param, Object data, ProceedingJoinPoint point) {
        ExportActuatorParam actuatorParam = new ExportActuatorParam();
        actuatorParam.setCommonFilePath(this.webEnvConfig.getExport().get("common-file-path") == null ? "" : this.webEnvConfig.getExport().get("common-file-path"));
        actuatorParam.setPrefix(this.webEnvConfig.getExport().get("prefix") == null ? "" : this.webEnvConfig.getExport().get("prefix"));
        actuatorParam.setParam(param);
        ExportActuator actuator = this.createExportActuator(data, point, actuatorParam);
        List<ExportTitle> titles = actuator.getTitles();
        actuator.createFile();
        try {
            actuator.writeTitles(titles);
            if (data != null) {
                actuator.writeContent();
            }
            Object object = actuator.getObject();
            return object;
        }
        finally {
            try {
                actuator.close();
            }
            catch (IOException e) {
                throw new SystemErrorException();
            }
        }
    }

    protected abstract ExportActuator createExportActuator(Object var1, ProceedingJoinPoint var2, ExportActuatorParam var3);

    public int getOrder() {
        return 0;
    }

    protected ExportActuatorConfig getActuatorConfig() {
        ExportActuatorConfig config = new ExportActuatorConfig();
        config.setFactories(this.merger.getFactories());
        config.setConvertors(this.merger.getConvertors());
        return config;
    }
}

