/*
 * Decompiled with CFR 0.152.
 */
package pub.carzy.export_file.spring_bean;

import cn.hutool.core.collection.ConcurrentHashSet;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Resource;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.context.annotation.Import;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;
import pub.carzy.export_file.exce.ExportFileEmptyException;
import pub.carzy.export_file.exce.ExportNotSupportedException;
import pub.carzy.export_file.exce.SystemErrorException;
import pub.carzy.export_file.file_export.ExportFiler;
import pub.carzy.export_file.file_export.ExportMethod;
import pub.carzy.export_file.file_export.entity.ExportRequestParam;
import pub.carzy.export_file.spring_bean.ExportBeans;
import pub.carzy.export_file.spring_bean.WebEnvConfig;
import pub.carzy.export_file.template.ExportAopCallback;

@Component
@Aspect
@Import(value={ExportBeans.class, WebEnvConfig.class})
public class AopExportFileConfig {
    private final Map<Method, ExportMethod> exportMethods = new ConcurrentHashMap<Method, ExportMethod>();
    private final Set<Method> skipMethods = new ConcurrentHashSet();
    @Resource
    private List<ExportFiler> filers;
    @Resource
    private ExportAopCallback callback;

    @Pointcut(value="@within(org.springframework.stereotype.Controller)")
    public void webPointcut() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExportMethod getMethodAnnotation(Method method) {
        if (this.exportMethods.containsKey(method)) {
            return this.exportMethods.get(method);
        }
        Map<Method, ExportMethod> map = this.exportMethods;
        synchronized (map) {
            if (this.exportMethods.containsKey(method)) {
                return this.exportMethods.get(method);
            }
            ExportMethod exportMethod = method.getAnnotation(ExportMethod.class);
            if (exportMethod == null) {
                this.skipMethods.add(method);
                throw new ExportNotSupportedException("\u5f53\u524d\u65b9\u6cd5\u4e0d\u652f\u6301\u5bfc\u51fa");
            }
            this.exportMethods.put(method, exportMethod);
            return exportMethod;
        }
    }

    private Method getTargetMethod(JoinPoint joinPoint) {
        Signature s = joinPoint.getSignature();
        if (!(s instanceof MethodSignature)) {
            throw new SystemErrorException("\u5bfc\u51fa\u7cfb\u7edf\u5f02\u5e38");
        }
        MethodSignature signature = (MethodSignature)s;
        return signature.getMethod();
    }

    @Around(value="webPointcut()")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        Object[] args = point.getArgs();
        ExportRequestParam exportRequestParam = this.callback.getExportParam(args);
        if (exportRequestParam == null) {
            return point.proceed();
        }
        Method method = this.getTargetMethod((JoinPoint)point);
        if (this.skipMethods.contains(method)) {
            throw new ExportNotSupportedException("\u5f53\u524d\u65b9\u6cd5\u4e0d\u652f\u6301\u5bfc\u51fa");
        }
        ExportMethod exportMethod = this.getMethodAnnotation(method);
        if (ObjectUtils.isEmpty((Object)exportRequestParam.getFilename())) {
            exportRequestParam.setFilename(exportMethod.filename());
        }
        if (exportRequestParam.getFileType() == null) {
            exportRequestParam.setFileType(exportMethod.fileType());
        }
        this.callback.updatePageSize(args);
        Object data = point.proceed(args);
        Object exportResult = null;
        for (ExportFiler filer : this.filers) {
            if (!filer.match(exportRequestParam, data)) continue;
            exportResult = filer.export(exportRequestParam, data, point);
            break;
        }
        if (ObjectUtils.isEmpty(exportResult)) {
            throw new ExportFileEmptyException();
        }
        return this.callback.responseResult(exportRequestParam, point, exportResult);
    }
}

