/*
 * Decompiled with CFR 0.152.
 */
package pub.carzy.export_file.util;

import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import jdk.nashorn.internal.ir.annotations.Ignore;
import pub.carzy.export_file.exce.ExportBaseException;

public class ObjectUtils {
    public static final String[] ignoreMethod;
    public static final String[] ignoreField;
    public static final Class[] simpleClasses;
    public static final Class[] valueOfClasses;
    public static final Class[] constructionClasses;
    public static final Class[] ignoreAnnotations;
    public static final String COUNT_STRING;

    public static boolean isEmpty(Object object) {
        if (ObjectUtils.isNull(object)) {
            return true;
        }
        if (object instanceof Collection) {
            return ((Collection)object).size() <= 0;
        }
        if (object instanceof Map) {
            return ((Map)object).size() <= 0;
        }
        return "".equals(object.toString());
    }

    public static boolean isNotEmpty(Object object) {
        return !ObjectUtils.isEmpty(object);
    }

    public static boolean isNull(Object object) {
        return object == null;
    }

    public static <O> void setValueOrDefault(O value, O defaultValue, Consumer<O> consumer) {
        ObjectUtils.setValueOrDefault(value, defaultValue, consumer, e -> null);
    }

    public static <O> void setValueOrDefault(O value, O defaultValue, Consumer<O> consumer, Function<Exception, ? extends RuntimeException> function) {
        block4: {
            try {
                if (ObjectUtils.isEmpty(value)) {
                    consumer.accept(defaultValue);
                } else {
                    consumer.accept(value);
                }
            }
            catch (Exception e) {
                RuntimeException runtimeException = function.apply(e);
                if (runtimeException == null) break block4;
                throw runtimeException;
            }
        }
    }

    public static boolean isNotNull(Object object) {
        return !ObjectUtils.isNull(object);
    }

    public static boolean isBlank(Object object) {
        if (ObjectUtils.isEmpty(object)) {
            return true;
        }
        return "".equals(object.toString().trim());
    }

    public static boolean isNotBlank(Object object) {
        return !ObjectUtils.isBlank(object);
    }

    public static void getAllMethods(Class clazz, Set<Method> allMethod) {
        Method[] methods;
        if (ObjectUtils.isSimpleType(clazz)) {
            return;
        }
        for (Method method : methods = clazz.getDeclaredMethods()) {
            boolean isIgnore = false;
            for (String s : ignoreMethod) {
                if (!method.getName().equals(s)) continue;
                isIgnore = true;
                break;
            }
            if (isIgnore || method.getAnnotation(Ignore.class) != null) continue;
            allMethod.add(method);
        }
        Class superclass = clazz.getSuperclass();
        if (superclass != Object.class && superclass.getAnnotation(Ignore.class) == null) {
            ObjectUtils.getAllMethods(superclass, allMethod);
        }
    }

    public static boolean isSimpleType(Class<?> type1) {
        boolean isSimple = false;
        for (Class c : simpleClasses) {
            if (type1 != c) continue;
            isSimple = true;
            break;
        }
        return isSimple;
    }

    public static boolean isMapOrCollection(Class<?> type1) {
        if (Collection.class.isAssignableFrom(type1)) {
            return true;
        }
        return Map.class.isAssignableFrom(type1);
    }

    public static void getAllFields(Class clazz, Set<Field> fields) {
        Field[] declaredFields;
        if (ObjectUtils.isSimpleType(clazz)) {
            return;
        }
        for (Field field : declaredFields = clazz.getDeclaredFields()) {
            boolean isIgnore = false;
            for (String s : ignoreField) {
                if (!field.getName().equals(s)) continue;
                isIgnore = true;
                break;
            }
            if (isIgnore || field.getAnnotation(Ignore.class) != null) continue;
            fields.add(field);
        }
        Class superclass = clazz.getSuperclass();
        if (superclass != null && superclass != Object.class && superclass.getAnnotation(Ignore.class) == null) {
            ObjectUtils.getAllFields(superclass, fields);
        }
    }

    public static String uppercaseFirst(String string) {
        if (string == null) {
            return null;
        }
        if ("".equals(string)) {
            return "";
        }
        if (string.length() <= 1) {
            return string.toUpperCase();
        }
        char[] chars = string.toCharArray();
        if (chars[0] >= 'a' && chars[0] <= 'z') {
            chars[0] = (char)(chars[0] - 32);
        }
        return new String(chars);
    }

    public static Class getCommonMapOrCollection(Class<?> type) {
        if (type == List.class) {
            return ArrayList.class;
        }
        if (type == Map.class) {
            return LinkedHashMap.class;
        }
        if (type == Set.class) {
            return LinkedHashSet.class;
        }
        return type;
    }

    public static Object getSimpleValue(Class type, Object o, Annotation[] annotations) {
        if (type == String.class) {
            return o.toString();
        }
        Object value = null;
        boolean skip = false;
        for (Class clazz : valueOfClasses) {
            if (type != clazz) continue;
            try {
                Method valueOf = clazz.getDeclaredMethod("valueOf", String.class);
                value = valueOf.invoke(null, o.toString());
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new ExportBaseException("\u53c2\u6570\u7c7b\u578b\u683c\u5f0f\u9519\u8bef!");
            }
            skip = true;
            break;
        }
        if (skip) {
            return value;
        }
        for (Class clazz : constructionClasses) {
            if (clazz != type) continue;
            try {
                Constructor constructor = clazz.getConstructor(String.class);
                value = constructor.newInstance(o.toString());
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new ExportBaseException("\u53c2\u6570\u7c7b\u578b\u683c\u5f0f\u9519\u8bef!");
            }
            skip = true;
            break;
        }
        if (skip) {
            return value;
        }
        if (type == Date.class) {
            value = DateFormat.getDateTimeInstance().format(o.toString());
        }
        return value;
    }

    public static <T extends Annotation> T getAnnotationByClass(Class clazz, Class<T> annotationClass) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = clazz.getAnnotations()) {
            if (annotation.annotationType() != annotationClass) continue;
            return (T)annotation;
        }
        for (Annotation annotation : annotations) {
            T byClass;
            boolean skip = false;
            for (Class ignoreClass : ignoreAnnotations) {
                if (annotation.annotationType() != ignoreClass) continue;
                skip = true;
                break;
            }
            if (skip || (byClass = ObjectUtils.getAnnotationByClass(annotation.annotationType(), annotationClass)) == null) continue;
            return byClass;
        }
        Class superclass = clazz.getSuperclass();
        if (superclass == null || superclass == Object.class) {
            return null;
        }
        return ObjectUtils.getAnnotationByClass(superclass, annotationClass);
    }

    public static <T> boolean matchClass(Class<?> aClass, Class<T> clazz) {
        Class<?>[] interfaces;
        if (aClass == null) {
            return false;
        }
        if (aClass == clazz) {
            return true;
        }
        if (aClass == Object.class) {
            return false;
        }
        for (Class<?> interfaceClass : interfaces = aClass.getInterfaces()) {
            if (interfaceClass == clazz) {
                return true;
            }
            if (!ObjectUtils.matchClass(interfaceClass, clazz)) continue;
            return true;
        }
        return ObjectUtils.matchClass(aClass.getSuperclass(), clazz);
    }

    public static <T> T transform(Class<T> type, Object data) {
        Object value = null;
        if (type == String.class) {
            return (T)data.toString();
        }
        for (Class clazz : valueOfClasses) {
            if (type != clazz) continue;
            try {
                Method valueOf = clazz.getDeclaredMethod("valueOf", String.class);
                value = valueOf.invoke(null, data.toString());
                if (value != null) {
                    return (T)value;
                }
                break;
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                throw new ExportBaseException("\u53c2\u6570\u7c7b\u578b\u683c\u5f0f\u9519\u8bef!");
            }
        }
        for (Class clazz : constructionClasses) {
            if (clazz != type) continue;
            try {
                Constructor constructor = clazz.getConstructor(String.class);
                value = constructor.newInstance(data.toString());
                if (value != null) {
                    return (T)value;
                }
                break;
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new ExportBaseException("\u53c2\u6570\u7c7b\u578b\u683c\u5f0f\u9519\u8bef!");
            }
        }
        if (type == Date.class) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                value = sdf.parse(data.toString());
            }
            catch (ParseException e) {
                value = DateFormat.getDateTimeInstance().format(data.toString());
            }
        }
        return (T)value;
    }

    public static <T> T getCollectionOrMapValue(Class<T> type, Object o, Annotation[] annotations) {
        Object obj = null;
        if (Collection.class.isAssignableFrom(type)) {
            Collection collection = null;
            if (List.class == type) {
                collection = new ArrayList();
            } else if (Set.class == type) {
                collection = new LinkedHashSet();
            } else if (!type.isInterface() && !Modifier.isAbstract(type.getModifiers())) {
                try {
                    collection = (Collection)type.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                    throw new ExportBaseException("\u5b9e\u4f8b\u5316\u5931\u8d25!");
                }
            }
            if (collection == null) {
                return null;
            }
            if (o instanceof Collection) {
                collection.addAll((Collection)o);
            } else {
                collection.add(o);
            }
            obj = collection;
        } else if (Map.class == type) {
            LinkedHashMap map = new LinkedHashMap();
            if (o instanceof Map) {
                map.putAll((Map)o);
            }
            obj = map;
        } else if (Map.class.isAssignableFrom(type) && !type.isInterface() && !Modifier.isAbstract(type.getModifiers())) {
            try {
                Map map = (Map)type.getConstructor(new Class[0]).newInstance(new Object[0]);
                if (o instanceof Map) {
                    map.putAll((Map)o);
                }
                obj = map;
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new ExportBaseException("\u5b9e\u4f8b\u5316\u5931\u8d25!");
            }
        }
        return (T)obj;
    }

    public static final <T> T copyProperties(Object source, Class<T> tClass) {
        try {
            T t = tClass.newInstance();
            HashSet<Field> srcFields = new HashSet<Field>();
            HashSet<Field> destFields = new HashSet<Field>();
            ObjectUtils.getAllFields(source.getClass(), srcFields);
            ObjectUtils.getAllFields(tClass, destFields);
            Set<Method> srcMethods = new HashSet<Method>();
            Set<Method> destMethods = new HashSet<Method>();
            ObjectUtils.getAllMethods(source.getClass(), srcMethods);
            ObjectUtils.getAllMethods(tClass, destMethods);
            srcMethods = srcMethods.stream().filter(method -> method.getName().startsWith("get")).collect(Collectors.toSet());
            destMethods = destMethods.stream().filter(method -> method.getName().startsWith("set")).collect(Collectors.toSet());
            block2: for (Field destField : destFields) {
                String destName = destField.getName();
                Class<?> destType = destField.getType();
                for (Field srcField : srcFields) {
                    String srcName = srcField.getName();
                    Class<?> srcType = srcField.getType();
                    if (!destName.equals(srcName) || destType != srcType) continue;
                    String getMethodName = "get" + ObjectUtils.uppercaseFirst(srcName);
                    String setMethodName = "set" + ObjectUtils.uppercaseFirst(destName);
                    Method destMethod = null;
                    Method srcMethod = null;
                    for (Method method2 : destMethods) {
                        if (!method2.getName().equals(setMethodName)) continue;
                        destMethod = method2;
                        break;
                    }
                    for (Method method2 : srcMethods) {
                        if (!method2.getName().equals(getMethodName)) continue;
                        srcMethod = method2;
                        break;
                    }
                    Object value = null;
                    if (srcMethod != null) {
                        value = srcMethod.invoke(source, new Object[0]);
                    } else {
                        srcField.setAccessible(true);
                        value = srcField.get(source);
                    }
                    if (value == null) continue block2;
                    if (destMethod != null) {
                        destMethod.invoke(t, value);
                        continue block2;
                    }
                    destField.setAccessible(true);
                    destField.set(t, value);
                    continue block2;
                }
            }
            return t;
        }
        catch (Exception e) {
            throw new RuntimeException("\u521b\u5efa\u5b9e\u4f8b\u5931\u8d25!");
        }
    }

    public static <T> String spliceSeparator(Collection<T> collection, String separator) {
        if (collection == null || collection.size() <= 0) {
            return null;
        }
        Iterator<T> iterator = collection.iterator();
        if (collection.size() == 1) {
            return iterator.next().toString();
        }
        if (collection.size() == 2) {
            return iterator.next().toString() + separator + iterator.next();
        }
        int i = 0;
        StringBuilder builder = new StringBuilder();
        while (iterator.hasNext()) {
            builder.append(iterator.next().toString());
            if (i < collection.size() - 1) {
                builder.append(separator);
            }
            ++i;
        }
        return builder.toString();
    }

    static {
        Method[] methods = Object.class.getDeclaredMethods();
        ignoreMethod = new String[methods.length];
        for (int i = 0; i < methods.length; ++i) {
            ObjectUtils.ignoreMethod[i] = methods[i].getName();
        }
        ignoreField = new String[0];
        simpleClasses = new Class[]{Byte.class, Short.class, Integer.class, Long.class, Double.class, Float.class, Character.class, String.class, BigInteger.class, BigDecimal.class, Date.class};
        valueOfClasses = new Class[]{Short.class, Integer.class, Long.class, Double.class, Float.class, Boolean.class};
        constructionClasses = new Class[]{BigInteger.class, BigDecimal.class};
        ignoreAnnotations = new Class[]{Target.class, Retention.class, Documented.class};
        COUNT_STRING = "SELECT count(1) FROM ";
    }
}

