package ro.dragossusi.resource

import kotlinx.coroutines.flow.*
import ro.dragossusi.ViewModel
import ro.dragossusi.coroutineScope
import ro.dragossusi.resource.flow.CompletionFlow
import ro.dragossusi.resource.flow.ObservableFlow

@Deprecated("loading is not tested")
abstract class BaseViewModel : ViewModel() {

    private val requests = MutableStateFlow<List<CompletionFlow>>(emptyList())

    protected val loadingStateFlow: StateFlow<Boolean> = requests.flatMapLatest {
        if (it.isEmpty()) flowOf(false)
        else {
            combine(*it.toTypedArray()) { resources ->
                resources.any {
                    it.isLoading
                }
            }
        }
    }.stateIn(coroutineScope, SharingStarted.Eagerly, false)

    protected fun <T> observableData() = ObservableFlow<DataResource<T>>().also {
        addLoadingSource(it.flow)
    }

    protected fun observableCompletion() = ObservableFlow<CompletionResource>().also {
        addLoadingSource(it.flow)
    }

    fun addLoadingSource(source: Flow<CompletionResource>) {
        requests.value += (requests.value + source)
    }

    fun removeLoadingSource(source: Flow<CompletionResource>) {
        requests.value = (requests.value - source)
    }

}