/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.sasscompiler;

import com.vaadin.sass.internal.ScssContext;
import com.vaadin.sass.internal.ScssStylesheet;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.pippo.core.PippoRuntimeException;
import ro.pippo.core.route.ClasspathResourceHandler;
import ro.pippo.core.route.RouteContext;

public class SassResourceHandler
extends ClasspathResourceHandler {
    private static final Logger log = LoggerFactory.getLogger(SassResourceHandler.class);
    private boolean minify;
    private Map<String, String> sourceMap = new ConcurrentHashMap<String, String>();

    public SassResourceHandler(String urlPath, String resourceBasePath) {
        super(urlPath, resourceBasePath);
    }

    public SassResourceHandler useMinimized(boolean minimized) {
        this.minify = minimized;
        return this;
    }

    protected void sendResource(URL resourceUrl, RouteContext routeContext) throws IOException {
        try {
            log.trace("Send css for '{}'", (Object)resourceUrl);
            ScssContext.UrlMode urlMode = ScssContext.UrlMode.ABSOLUTE;
            String identifier = resourceUrl.getFile();
            ScssStylesheet scssStylesheet = ScssStylesheet.get((String)identifier);
            if (scssStylesheet == null) {
                throw new Exception("ScssStylesheet is null for '" + identifier + "'");
            }
            String content = scssStylesheet.toString();
            String result = this.sourceMap.get(content);
            if (result == null) {
                scssStylesheet.compile(urlMode);
                StringWriter writer = new StringWriter();
                scssStylesheet.write((Writer)writer, this.minify);
                result = ((Object)writer).toString();
                if (routeContext.getApplication().getPippoSettings().isProd()) {
                    this.sourceMap.put(content, result);
                }
            }
            routeContext.getResponse().contentType("text/css");
            routeContext.getResponse().ok().send((CharSequence)result);
        }
        catch (Exception e) {
            throw new PippoRuntimeException((Throwable)e);
        }
    }
}

