/*
 * Decompiled with CFR 0.152.
 */
package rs.arthu.androidpvt.lib;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.MotionEvent;
import android.view.View;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.appcompat.app.AppCompatActivity;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.Observer;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import rs.arthu.androidpvt.lib.Args;
import rs.arthu.androidpvt.lib.Pvt;
import rs.arthu.androidpvt.lib.PvtState;
import rs.arthu.androidpvt.lib.PvtViewModel;
import rs.arthu.androidpvt.lib.PvtViewModelFactory;
import rs.arthu.androidpvt.lib.R;
import rs.arthu.androidpvt.lib.databinding.ActivityPvtBinding;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u0002:\u0001&B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\u000eH\u0002J\b\u0010\u0010\u001a\u00020\u000eH\u0002J\b\u0010\u0011\u001a\u00020\u000eH\u0002J\b\u0010\u0012\u001a\u00020\u000eH\u0002J\b\u0010\u0013\u001a\u00020\u000eH\u0002J\u0012\u0010\u0014\u001a\u00020\u000e2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0014J\b\u0010\u0017\u001a\u00020\u000eH\u0016J\u0012\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J&\u0010\u001c\u001a\u00020\u000e2\u001c\u0010\u001d\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!0\u001fj\u0002`\"0\u001eH\u0002J\u0010\u0010#\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020 H\u0002J\u0010\u0010%\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020 H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lrs/arthu/androidpvt/lib/PvtActivity;", "Landroidx/appcompat/app/AppCompatActivity;", "Lrs/arthu/androidpvt/lib/Pvt$StimulusListener;", "()V", "binding", "Lrs/arthu/androidpvt/lib/databinding/ActivityPvtBinding;", "stateObserver", "Landroidx/lifecycle/Observer;", "Lrs/arthu/androidpvt/lib/PvtState$State;", "viewModel", "Lrs/arthu/androidpvt/lib/PvtViewModel;", "viewModelFactory", "Lrs/arthu/androidpvt/lib/PvtViewModelFactory;", "displayComplete", "", "displayCountdown", "displayInstructions", "displayInterval", "displayInvalidReaction", "initViewModel", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onStimulus", "onTouchEvent", "", "event", "Landroid/view/MotionEvent;", "returnResults", "results", "", "Ljava/util/HashMap;", "", "", "Lrs/arthu/androidpvt/lib/Result;", "updateCountdown", "millisElapsed", "updateReactionDelay", "Builder", "AndroidPvtLib_release"})
public final class PvtActivity
extends AppCompatActivity
implements Pvt.StimulusListener {
    private ActivityPvtBinding binding;
    private PvtViewModel viewModel;
    private PvtViewModelFactory viewModelFactory;
    private final Observer<PvtState.State> stateObserver = (Observer)new Observer<PvtState.State>(this){
        final /* synthetic */ PvtActivity this$0;

        public final void onChanged(PvtState.State it) {
            PvtState.State state = it;
            if (state instanceof PvtState.Instructions) {
                PvtActivity.access$displayInstructions(this.this$0);
            } else if (state instanceof PvtState.Countdown) {
                PvtActivity.access$displayCountdown(this.this$0);
            } else if (state instanceof PvtState.Interval) {
                PvtActivity.access$displayInterval(this.this$0);
            } else if (!(state instanceof PvtState.StimulusShowing)) {
                if (state instanceof PvtState.InvalidReaction) {
                    PvtActivity.access$displayInvalidReaction(this.this$0);
                } else if (!(state instanceof PvtState.ValidReaction)) {
                    if (state instanceof PvtState.Complete) {
                        PvtActivity.access$displayComplete(this.this$0);
                    } else {
                        throw (Throwable)new IllegalStateException();
                    }
                }
            }
        }
        {
            this.this$0 = pvtActivity;
        }
    };

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        ActivityPvtBinding activityPvtBinding = ActivityPvtBinding.inflate(this.getLayoutInflater());
        Intrinsics.checkNotNullExpressionValue((Object)activityPvtBinding, (String)"ActivityPvtBinding.inflate(layoutInflater)");
        ActivityPvtBinding activityPvtBinding2 = this.binding = activityPvtBinding;
        if (activityPvtBinding2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
        }
        RelativeLayout relativeLayout = activityPvtBinding2.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)relativeLayout, (String)"binding.root");
        RelativeLayout view = relativeLayout;
        this.setContentView((View)view);
        this.initViewModel();
    }

    private final void initViewModel() {
        Intent intent = this.getIntent();
        Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"intent");
        Bundle intentExtras = intent.getExtras();
        Args pvtArgs = Args.Companion.fromBundle(intentExtras);
        this.viewModelFactory = new PvtViewModelFactory(pvtArgs);
        ViewModelStoreOwner viewModelStoreOwner = (ViewModelStoreOwner)this;
        PvtViewModelFactory pvtViewModelFactory = this.viewModelFactory;
        if (pvtViewModelFactory == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModelFactory");
        }
        ViewModel viewModel = new ViewModelProvider(viewModelStoreOwner, (ViewModelProvider.Factory)pvtViewModelFactory).get(PvtViewModel.class);
        Intrinsics.checkNotNullExpressionValue((Object)viewModel, (String)"ViewModelProvider(this, \u2026PvtViewModel::class.java)");
        PvtViewModel pvtViewModel = this.viewModel = (PvtViewModel)viewModel;
        if (pvtViewModel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
        }
        pvtViewModel.getPvt$AndroidPvtLib_release().setStimulusListener$AndroidPvtLib_release(this);
        PvtViewModel pvtViewModel2 = this.viewModel;
        if (pvtViewModel2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
        }
        pvtViewModel2.getCountdown().observe((LifecycleOwner)this, (Observer)new Observer<String>(this){
            final /* synthetic */ PvtActivity this$0;

            public final void onChanged(String it) {
                String string2 = it;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it");
                PvtActivity.access$updateCountdown(this.this$0, string2);
            }
            {
                this.this$0 = pvtActivity;
            }
        });
        PvtViewModel pvtViewModel3 = this.viewModel;
        if (pvtViewModel3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
        }
        pvtViewModel3.getReactionDelay().observe((LifecycleOwner)this, (Observer)new Observer<String>(this){
            final /* synthetic */ PvtActivity this$0;

            public final void onChanged(String it) {
                String string2 = it;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it");
                PvtActivity.access$updateReactionDelay(this.this$0, string2);
            }
            {
                this.this$0 = pvtActivity;
            }
        });
        PvtViewModel pvtViewModel4 = this.viewModel;
        if (pvtViewModel4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
        }
        pvtViewModel4.getResults().observe((LifecycleOwner)this, (Observer)new Observer<List<? extends HashMap<String, Number>>>(this){
            final /* synthetic */ PvtActivity this$0;

            public final void onChanged(List<? extends HashMap<String, Number>> it) {
                List<? extends HashMap<String, Number>> list = it;
                Intrinsics.checkNotNullExpressionValue(list, (String)"it");
                PvtActivity.access$returnResults(this.this$0, list);
            }
            {
                this.this$0 = pvtActivity;
            }
        });
        PvtViewModel pvtViewModel5 = this.viewModel;
        if (pvtViewModel5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
        }
        pvtViewModel5.getPvtState().observe((LifecycleOwner)this, this.stateObserver);
    }

    public boolean onTouchEvent(@Nullable MotionEvent event) {
        super.onTouchEvent(event);
        MotionEvent motionEvent = event;
        if (motionEvent != null) {
            if (motionEvent.getAction() == 0) {
                PvtViewModel pvtViewModel = this.viewModel;
                if (pvtViewModel == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
                }
                pvtViewModel.getPvt$AndroidPvtLib_release().handleActionDownTouchEvent();
            }
        }
        return true;
    }

    private final void updateCountdown(String millisElapsed) {
        ActivityPvtBinding activityPvtBinding = this.binding;
        if (activityPvtBinding == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
        }
        TextView textView = activityPvtBinding.textViewSub;
        Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"binding.textViewSub");
        textView.setText((CharSequence)millisElapsed);
    }

    private final void updateReactionDelay(String millisElapsed) {
        ActivityPvtBinding activityPvtBinding = this.binding;
        if (activityPvtBinding == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
        }
        TextView textView = activityPvtBinding.textViewMain;
        Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"binding.textViewMain");
        textView.setText((CharSequence)this.getString(R.string.reaction_delay, new Object[]{millisElapsed}));
    }

    private final void displayInstructions() {
        ActivityPvtBinding activityPvtBinding = this.binding;
        if (activityPvtBinding == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
        }
        View view = activityPvtBinding.viewStimulus;
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"binding.viewStimulus");
        view.setVisibility(8);
        ActivityPvtBinding activityPvtBinding2 = this.binding;
        if (activityPvtBinding2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
        }
        TextView textView = activityPvtBinding2.textViewMain;
        Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"binding.textViewMain");
        textView.setVisibility(0);
        ActivityPvtBinding activityPvtBinding3 = this.binding;
        if (activityPvtBinding3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
        }
        TextView textView2 = activityPvtBinding3.textViewMain;
        Intrinsics.checkNotNullExpressionValue((Object)textView2, (String)"binding.textViewMain");
        textView2.setText((CharSequence)this.getString(R.string.instructions));
        ActivityPvtBinding activityPvtBinding4 = this.binding;
        if (activityPvtBinding4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
        }
        TextView textView3 = activityPvtBinding4.textViewSub;
        Intrinsics.checkNotNullExpressionValue((Object)textView3, (String)"binding.textViewSub");
        textView3.setVisibility(8);
        ActivityPvtBinding activityPvtBinding5 = this.binding;
        if (activityPvtBinding5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
        }
        TextView textView4 = activityPvtBinding5.textViewSub;
        Intrinsics.checkNotNullExpressionValue((Object)textView4, (String)"binding.textViewSub");
        textView4.setText((CharSequence)"");
    }

    private final void displayCountdown() {
        ActivityPvtBinding activityPvtBinding = this.binding;
        if (activityPvtBinding == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
        }
        View view = activityPvtBinding.viewStimulus;
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"binding.viewStimulus");
        view.setVisibility(8);
        ActivityPvtBinding activityPvtBinding2 = this.binding;
        if (activityPvtBinding2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
        }
        TextView textView = activityPvtBinding2.textViewMain;
        Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"binding.textViewMain");
        textView.setText((CharSequence)this.getString(R.string.ready_message));
        ActivityPvtBinding activityPvtBinding3 = this.binding;
        if (activityPvtBinding3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
        }
        TextView textView2 = activityPvtBinding3.textViewMain;
        Intrinsics.checkNotNullExpressionValue((Object)textView2, (String)"binding.textViewMain");
        textView2.setVisibility(0);
        ActivityPvtBinding activityPvtBinding4 = this.binding;
        if (activityPvtBinding4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
        }
        TextView textView3 = activityPvtBinding4.textViewSub;
        Intrinsics.checkNotNullExpressionValue((Object)textView3, (String)"binding.textViewSub");
        textView3.setVisibility(0);
    }

    private final void displayInterval() {
        ActivityPvtBinding activityPvtBinding = this.binding;
        if (activityPvtBinding == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
        }
        TextView textView = activityPvtBinding.textViewMain;
        Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"binding.textViewMain");
        textView.setText((CharSequence)"");
        ActivityPvtBinding activityPvtBinding2 = this.binding;
        if (activityPvtBinding2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
        }
        TextView textView2 = activityPvtBinding2.textViewMain;
        Intrinsics.checkNotNullExpressionValue((Object)textView2, (String)"binding.textViewMain");
        textView2.setVisibility(8);
        ActivityPvtBinding activityPvtBinding3 = this.binding;
        if (activityPvtBinding3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
        }
        TextView textView3 = activityPvtBinding3.textViewSub;
        Intrinsics.checkNotNullExpressionValue((Object)textView3, (String)"binding.textViewSub");
        textView3.setText((CharSequence)"");
        ActivityPvtBinding activityPvtBinding4 = this.binding;
        if (activityPvtBinding4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
        }
        TextView textView4 = activityPvtBinding4.textViewSub;
        Intrinsics.checkNotNullExpressionValue((Object)textView4, (String)"binding.textViewSub");
        textView4.setVisibility(8);
        ActivityPvtBinding activityPvtBinding5 = this.binding;
        if (activityPvtBinding5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
        }
        View view = activityPvtBinding5.viewStimulus;
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"binding.viewStimulus");
        view.setVisibility(8);
    }

    @Override
    public void onStimulus() {
        ActivityPvtBinding activityPvtBinding = this.binding;
        if (activityPvtBinding == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
        }
        View view = activityPvtBinding.viewStimulus;
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"binding.viewStimulus");
        view.setVisibility(0);
        ActivityPvtBinding activityPvtBinding2 = this.binding;
        if (activityPvtBinding2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
        }
        TextView textView = activityPvtBinding2.textViewMain;
        Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"binding.textViewMain");
        textView.setVisibility(0);
    }

    private final void displayInvalidReaction() {
        ActivityPvtBinding activityPvtBinding = this.binding;
        if (activityPvtBinding == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
        }
        View view = activityPvtBinding.viewStimulus;
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"binding.viewStimulus");
        view.setVisibility(8);
        ActivityPvtBinding activityPvtBinding2 = this.binding;
        if (activityPvtBinding2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
        }
        TextView textView = activityPvtBinding2.textViewMain;
        Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"binding.textViewMain");
        textView.setText((CharSequence)this.getString(R.string.invalid_reaction));
        ActivityPvtBinding activityPvtBinding3 = this.binding;
        if (activityPvtBinding3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
        }
        TextView textView2 = activityPvtBinding3.textViewMain;
        Intrinsics.checkNotNullExpressionValue((Object)textView2, (String)"binding.textViewMain");
        textView2.setVisibility(0);
    }

    private final void displayComplete() {
        ActivityPvtBinding activityPvtBinding = this.binding;
        if (activityPvtBinding == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
        }
        View view = activityPvtBinding.viewStimulus;
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"binding.viewStimulus");
        view.setVisibility(8);
        ActivityPvtBinding activityPvtBinding2 = this.binding;
        if (activityPvtBinding2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
        }
        TextView textView = activityPvtBinding2.textViewMain;
        Intrinsics.checkNotNullExpressionValue((Object)textView, (String)"binding.textViewMain");
        textView.setVisibility(0);
        ActivityPvtBinding activityPvtBinding3 = this.binding;
        if (activityPvtBinding3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
        }
        TextView textView2 = activityPvtBinding3.textViewMain;
        Intrinsics.checkNotNullExpressionValue((Object)textView2, (String)"binding.textViewMain");
        textView2.setText((CharSequence)this.getString(R.string.test_complete));
    }

    private final void returnResults(List<? extends HashMap<String, Number>> results) {
        Intent returnIntent = new Intent();
        List<? extends HashMap<String, Number>> list = results;
        if (list == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.io.Serializable");
        }
        returnIntent.putExtra("pvtResultsKey", (Serializable)((Object)list));
        this.setResult(-1, returnIntent);
        this.finish();
    }

    public static final /* synthetic */ void access$updateCountdown(PvtActivity $this, String millisElapsed) {
        $this.updateCountdown(millisElapsed);
    }

    public static final /* synthetic */ void access$updateReactionDelay(PvtActivity $this, String millisElapsed) {
        $this.updateReactionDelay(millisElapsed);
    }

    public static final /* synthetic */ void access$returnResults(PvtActivity $this, List results) {
        $this.returnResults(results);
    }

    public static final /* synthetic */ void access$displayInstructions(PvtActivity $this) {
        $this.displayInstructions();
    }

    public static final /* synthetic */ void access$displayCountdown(PvtActivity $this) {
        $this.displayCountdown();
    }

    public static final /* synthetic */ void access$displayInterval(PvtActivity $this) {
        $this.displayInterval();
    }

    public static final /* synthetic */ void access$displayInvalidReaction(PvtActivity $this) {
        $this.displayInvalidReaction();
    }

    public static final /* synthetic */ void access$displayComplete(PvtActivity $this) {
        $this.displayComplete();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0004J\u0016\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0004J\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0017\u001a\u00020\u0004J\u000e\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0004J\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u000bR\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u0012\u0010\b\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u0012\u0010\t\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0005R\u0012\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\f\u00a8\u0006\u001c"}, d2={"Lrs/arthu/androidpvt/lib/PvtActivity$Builder;", "", "()V", "countDownTime", "", "Ljava/lang/Long;", "maxInterval", "minInterval", "postResponseDelay", "stimulusTimeout", "testCount", "", "Ljava/lang/Integer;", "build", "Landroid/content/Intent;", "context", "Landroid/content/Context;", "withCountdownTime", "time", "withInterval", "min", "max", "withPostResponseDelay", "delay", "withStimulusTimeout", "timeout", "withTestCount", "count", "AndroidPvtLib_release"})
    public static final class Builder {
        private Integer testCount;
        private Long minInterval;
        private Long maxInterval;
        private Long countDownTime;
        private Long stimulusTimeout;
        private Long postResponseDelay;

        @NotNull
        public final Builder withTestCount(int count) {
            this.testCount = count;
            return this;
        }

        @NotNull
        public final Builder withInterval(long min, long max) {
            this.minInterval = min;
            this.maxInterval = max;
            return this;
        }

        @NotNull
        public final Builder withCountdownTime(long time) {
            this.countDownTime = time;
            return this;
        }

        @NotNull
        public final Builder withStimulusTimeout(long timeout) {
            this.stimulusTimeout = timeout;
            return this;
        }

        @NotNull
        public final Builder withPostResponseDelay(long delay) {
            this.postResponseDelay = delay;
            return this;
        }

        @NotNull
        public final Intent build(@NotNull Context context) {
            Intent intent;
            block5: {
                boolean bl;
                boolean bl2;
                Number number;
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                intent = new Intent(context, PvtActivity.class);
                Integer n = this.testCount;
                if (n != null) {
                    number = n;
                    bl2 = false;
                    bl = false;
                    int it = ((Number)number).intValue();
                    boolean bl3 = false;
                    intent.putExtra("testCount", it);
                }
                Long l = this.minInterval;
                if (l != null) {
                    number = l;
                    bl2 = false;
                    bl = false;
                    long it = ((Number)number).longValue();
                    boolean bl4 = false;
                    intent.putExtra("minInterval", it);
                }
                Long l2 = this.maxInterval;
                if (l2 != null) {
                    number = l2;
                    bl2 = false;
                    bl = false;
                    long it = ((Number)number).longValue();
                    boolean bl5 = false;
                    intent.putExtra("maxInterval", it);
                }
                Long l3 = this.countDownTime;
                if (l3 != null) {
                    number = l3;
                    bl2 = false;
                    bl = false;
                    long it = ((Number)number).longValue();
                    boolean bl6 = false;
                    intent.putExtra("countdownTime", it);
                }
                Long l4 = this.stimulusTimeout;
                if (l4 != null) {
                    number = l4;
                    bl2 = false;
                    bl = false;
                    long it = ((Number)number).longValue();
                    boolean bl7 = false;
                    intent.putExtra("stimulusTimeout", it);
                }
                Long l5 = this.postResponseDelay;
                if (l5 == null) break block5;
                number = l5;
                bl2 = false;
                bl = false;
                long it = ((Number)number).longValue();
                boolean bl8 = false;
                intent.putExtra("postResponseDelay", it);
            }
            return intent;
        }
    }
}

