/*
 * Decompiled with CFR 0.152.
 */
package ru.curs.adocwrapper.inline.text;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import ru.curs.adocwrapper.inline.text.AdocText;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\b\u001a\u00020\u0003H\u0016J\b\u0010\t\u001a\u00020\u0003H\u0016J\b\u0010\n\u001a\u00020\u0003H\u0016R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lru/curs/adocwrapper/inline/text/Link;", "Lru/curs/adocwrapper/inline/text/AdocText;", "text", "", "url", "(Ljava/lang/String;Ljava/lang/String;)V", "getUrl", "()Ljava/lang/String;", "toHabrMd", "toString", "toText", "asciidoc-kotlin-wrapper"})
public final class Link
extends AdocText {
    @NotNull
    private final String url;

    public Link(@NotNull String text, @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        super(text);
        this.url = url;
        super.checkValid();
        String urlPattern = "^(https?|ftp|file)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]";
        if (!new Regex(urlPattern).matches((CharSequence)this.url)) {
            throw new Exception("URL [" + this.url + "] should match [" + urlPattern + ']');
        }
    }

    @NotNull
    public final String getUrl() {
        return this.url;
    }

    @Override
    @NotNull
    public String toString() {
        return this.url + '[' + this.getText() + ']';
    }

    @Override
    @NotNull
    public String toHabrMd() {
        return '[' + this.getText() + "](" + this.url + ')';
    }

    @Override
    @NotNull
    public String toText() {
        return this.getText();
    }
}

