package ru.curs.adocwrapper.block.image

import ru.curs.adocwrapper.block.StructuralNode
import java.io.InputStream
import java.util.*

class Image : StructuralNode() {
    private var image = ""
    override fun toString(): String {
        return image
    }

    fun path(path: String) {
        image = "image::$path[]\n"
    }

    fun base64(encodedString: String) {
        image = "image::data:image/png;base64,$encodedString[]\n"
    }

    fun base64(inputStream: InputStream) {
        val sourceBytes: ByteArray = inputStream.readBytes()
        val encodedString = Base64.getEncoder().encodeToString(sourceBytes)
        image = "image::data:image/png;base64,$encodedString[]\n"
    }
}
