package ru.curs.adocwrapper.block.table

import ru.curs.adocwrapper.block.StructuralNode


open class Table : StructuralNode() {
    private var roles = ""
    override fun toString(): String {
        var returnString = "\n\n${getBlockMetaSyntax()}$roles|===\n"
        blocks.forEach {tableData -> returnString += tableData.toString() + "\n"}
        returnString += "|===\n"
        return returnString
    }

    fun td(init: TableData.() -> Unit): TableData {
        val tData = TableData()
        tData.apply(init)
        this.blocks.add(tData)
        return tData
    }

    fun role(vararg role: String) {
        role.forEach { roles += ".$it" }
        roles = "[$roles]\n"
    }
}
