package ru.curs.adocwrapper.inline

open class UnsafeInline(string: String) : Inline(string) {
    private val keyCharacters = setOf('*', '-', '.', ':', ';', '[', '{')

    init {
        if (text.any(keyCharacters::contains)) {
            this.makeSafe()
        }
    }

    open fun makeSafe() {
        this.text = "+++$text+++"
    }
}
