package ru.curs.adocwrapper.utils

import ru.curs.adocwrapper.inline.Inline

class IdString(string: String) : Inline(string) {
    override fun checkValid() {
        val pattern = "[a-zA-Zа-яА-Я_][a-zA-Z-аяА-Я0-9_-]*"
        if (! (Regex(pattern) matches text)) {
            throw Exception("String [$text] should match [$pattern]")
        }
    }
}
