package ru.curs.adocwrapper.block.image

import ru.curs.adocwrapper.block.StructuralNode
import java.io.InputStream
import java.util.*

class Image : StructuralNode() {
    private var image = ""
    override fun toString(): String {
        return image
    }

    fun path(path: String) {
        image = "\nimage::$path[]\n"
    }

    fun base64(encodedString: String, format: ImageFormat) {
        image = "\nimage::data:image/${format.extension};base64,$encodedString[]\n"
    }

    fun base64(inputStream: InputStream, format: ImageFormat) {
        val sourceBytes: ByteArray = inputStream.readBytes()
        val encodedString = Base64.getEncoder().encodeToString(sourceBytes)
        image = "\nimage::data:image/${format.extension};base64,$encodedString[]\n"
    }

    enum class ImageFormat(val extension: String) {
        PNG("png"),
        JPEG("jpeg")
    }
}
