package ru.curs.adocwrapper.block.paragraph

import ru.curs.adocwrapper.block.NodeType
import ru.curs.adocwrapper.block.ParaType
import ru.curs.adocwrapper.block.StructuralNode
import ru.curs.adocwrapper.block.video.Video
import ru.curs.adocwrapper.inline.Inline
import ru.curs.adocwrapper.inline.InlineContent
import ru.curs.adocwrapper.inline.text.Link

class Paragraph : StructuralNode() {
    private var ruleExeptions: Set<String> = setOf()
    private val thisPara = this
    override val type = NodeType.Para
    var paraType = ParaType.Normal

    fun ignoreRules(vararg rules: String) {
        this.ruleExeptions = rules.toSet()
    }

    override fun toString(): String {
        if (paraType == ParaType.FirstList) {
            return "$inlineContent"
        } else if (paraType == ParaType.OtherList) {
            return "${getBlockMetaSyntax()}$inlineContent"
        }
        return "\n\n${getBlockMetaSyntax()}$inlineContent"
    }

    override fun toHabrMd(): String {
        if (paraType == ParaType.FirstList) {
            return inlineContent.toHabrMd()
        } else if (paraType == ParaType.OtherList) {
            return "${getBlockMetaSyntax()}${inlineContent.toHabrMd()}"
        }
        return "\n\n${getBlockMetaSyntax()}${inlineContent.toHabrMd()}\n\n<cut/>"
    }

    override fun toText(): String {
        val inlineText = inlineContent.toText()
        if (paraType == ParaType.FirstList) {
            return inlineText
        } else if (paraType == ParaType.OtherList) {
            return "${getBlockMetaSyntax()}$inlineText"
        }
        return "\n\n${getBlockMetaSyntax()}$inlineText"
    }

    operator fun String.unaryPlus(): InlineContent {
        thisPara.text(this)
        return inlineContent
    }

    operator fun Inline?.unaryPlus(): InlineContent {
        thisPara.inlineContent.add(Inline(this?.text))
        return inlineContent
    }

    operator fun Video.unaryPlus(): InlineContent {
        thisPara.inlineContent.add(video(this.text!!))
        return inlineContent
    }

    operator fun Link.unaryPlus(): InlineContent {
        thisPara.inlineContent.add(link(this.text!!, this.url))
        return inlineContent
    }

    operator fun InlineContent.plus(text: String): InlineContent {
        thisPara.text(text)
        return inlineContent
    }

    operator fun InlineContent.plus(link: Link): InlineContent {
        thisPara.inlineContent.add(link(link.text!!, link.url))
        return inlineContent
    }

    public override fun text(string: String) {
        return super.text(string)
    }

}
