package ru.curs.adocwrapper.block.table

import ru.curs.adocwrapper.block.*
import ru.curs.adocwrapper.block.image.Image
import ru.curs.adocwrapper.block.paragraph.Paragraph

class TableData : StructuralNode() {
    private var align = ""
    private var colRowSpan = ""
    private var result = ""
    private var asciidocType = ""
    private var tableRoles = ""
    override fun toString(): String {
        result += "|"
        blocks.forEachIndexed { index, adocDSLStructuralNode ->
            result += if ((index == 0) and (adocDSLStructuralNode.type == NodeType.Para)) {
                val para = adocDSLStructuralNode as Paragraph
                "$para"
            } else {
                "\n\n$adocDSLStructuralNode"
            }
        }
        return "$colRowSpan$align$asciidocType$tableRoles$result"
    }

    public override fun p(init: Paragraph.() -> Unit): Paragraph {
        val newPara = super.p(init)
        newPara.paraType = if (blocks.size == 1) ParaType.FirstList else ParaType.OtherList
        return newPara
    }

    public override fun image(init: Image.() -> Unit): Image {
        return super.image(init)
    }

    fun role(vararg role: String) {
        role.forEach { tableRoles += ".$it" }
        tableRoles = "[$tableRoles]"
    }

    fun align (ha : HA? = null, va: VA? = null) {
        if (ha != null) {
            align += ha.align
        }
        if (va != null) {
            align += va.align
        }
    }

    fun colRowSpan(cols: Int? = null, rows: Int? = null) {
        colRowSpan = if (cols != null && rows == null) {
            "$cols+"
        } else if (cols == null && rows != null) {
            ".${rows}+"
        } else {
            "$cols.$rows+"
        }

        if (cols == null && rows == null) {
            colRowSpan = ""
        }
    }

    fun type(asciidoc: TDT) {
        asciidocType += asciidoc.type
    }
}
