package ru.curs.adocwrapper.inline

open class Inline(var text: String?) : Comparable<Inline> {
    var type = InlineContentType.NormalText
    private val keyCharacters = setOf('*', '-', '.', ':', ';', '[', '{', '_', '/')

    init {
        if (this.text.isNullOrBlank()) {
            this.text = "&#8203;"
        } else {
            val firstChar = this.text?.get(0)
            val lastChar = this.text?.get(this.text!!.length - 1)
            if (keyCharacters.contains(firstChar) && firstChar == lastChar) {
                this.text = this.text!!.substring(1, this.text!!.length - 1)
            }
        }
    }

    open fun checkValid() {
    }

    override fun compareTo(other: Inline): Int {
        return if (this.text!! > other.text.toString()) 1 else -1
    }

    override fun toString(): String {
        return text!!
    }

    open fun toHabrMd(): String {
        return toString()
    }

    open fun toText(): String {
        return toString()
    }
}
