package ru.curs.adocwrapper.inline

open class UnsafeInline(string: String?) : Inline(string) {
    private val keyCharacters = setOf('*', '-', '.', ':', ';', '[', '{', '_', '/')

    init {
        if (text?.any(keyCharacters::contains)!! && !text.equals("&#8203;")) {
            this.makeSafe()
        }
    }

    open fun makeSafe() {
        this.text = "+++$text+++"
    }
}
