package ru.curs.adocwrapper.utils

import ru.curs.adocwrapper.inline.Inline

class AttrNameString(string: String) : Inline(string) {
    override fun checkValid() {
        val pattern = "[a-z_][a-z0-9_-]*"
        if (! (Regex(pattern) matches text!!)) {
            throw Exception("String [$text] should match [$pattern]")
        }
    }
}
