package ru.curs.adocwrapper.utils

import ru.curs.adocwrapper.block.StructuralNode
import java.lang.IllegalStateException

class Discrete : StructuralNode() {
    private var level = 1
    fun level(level: Int?) {
        if (level!! > 3) {
            throw IllegalStateException("Level can't be higher than 3")
        }
        this.level = level
    }

    override fun toString(): String {
        var roleString = ""
        if (!roles.isEmpty()) {
            roles.forEach {
                roleString += ".$it"
            }
            roleString = "[${roleString}]\n"
        }
        return "\n${roleString}${"=".repeat(level + 1)} ${title.toString()}"
    }
}
