package ru.curs.adocwrapper.utils

import ru.curs.adocwrapper.inline.UnsafeInline

class TitleString(string: String) : UnsafeInline(string) {
    override fun toString(): String {
        return text!!
    }

    override fun checkValid() {
        val pattern = "[^\n]+"
        if (! (Regex(pattern) matches text!!)) {
            throw Exception("String [$text] should match [$pattern]")
        }
    }
}
