/*
 * Decompiled with CFR 0.152.
 */
package ru.fix.stdlib.reference;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GarbageGenerator {
    private static final Logger log = LoggerFactory.getLogger(GarbageGenerator.class);
    private Duration timeout = Duration.ofMinutes(1L);
    private Duration delay = Duration.ofMillis(100L);
    private int garbageSizePerIterationMB = 10;

    public GarbageGenerator setTimeout(Duration timeout) {
        this.timeout = timeout;
        return this;
    }

    public GarbageGenerator setDelay(Duration delay) {
        this.delay = delay;
        return this;
    }

    public GarbageGenerator setGarbageSizePerIterationMB(int garbageSizePerIterationMB) {
        this.garbageSizePerIterationMB = garbageSizePerIterationMB;
        return this;
    }

    public boolean generateGarbageAndWaitForCondition(Supplier<Boolean> condition) throws Exception {
        ArrayList<byte[]> data = new ArrayList<byte[]>();
        long start = System.currentTimeMillis();
        while (System.currentTimeMillis() - start <= this.timeout.toMillis()) {
            if (condition.get().booleanValue()) {
                return true;
            }
            log.info("Running time: " + Duration.of(System.currentTimeMillis() - start, ChronoUnit.MILLIS) + "\nOccupied memory: " + (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024L + " Kb");
            for (int mb = 0; mb < this.garbageSizePerIterationMB; ++mb) {
                for (int kb = 0; kb < 1024; ++kb) {
                    byte[] obj = new byte[1024];
                    data.add(obj);
                }
            }
            data.clear();
            Thread.sleep(this.delay.toMillis());
        }
        return condition.get();
    }
}

