/*
 * Decompiled with CFR 0.152.
 */
package ru.fix.stdlib.reference;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.fix.stdlib.reference.CleanableWeakReference;

public class ReferenceCleaner {
    private static final Logger log = LoggerFactory.getLogger(ReferenceCleaner.class);
    private static final ReferenceCleaner INSTANCE = new ReferenceCleaner();
    private ReferenceQueue<?> referenceQueue = new ReferenceQueue();
    private Set<CleanableWeakReference<?>> createdReferences = Collections.newSetFromMap(new ConcurrentHashMap());
    private AtomicReference<Thread> cleanerThread = new AtomicReference<Object>(null);

    private ReferenceCleaner() {
    }

    public static ReferenceCleaner getInstance() {
        return INSTANCE;
    }

    public <T, M> CleanableWeakReference<T> register(T referent, M metadata, BiConsumer<CleanableWeakReference<T>, M> cleaningAction) {
        Reference ref = new Reference(referent, metadata, cleaningAction, this.referenceQueue);
        this.createdReferences.add(ref);
        this.ensureThreadExist();
        return ref;
    }

    private void ensureThreadExist() {
        if (this.cleanerThread.get() != null) {
            return;
        }
        CleanerThread newThread = new CleanerThread(thread -> this.cleanerThread.compareAndSet((Thread)thread, (Thread)null));
        if (this.cleanerThread.compareAndSet(null, newThread)) {
            newThread.start();
        }
    }

    private class CleanerThread
    extends Thread {
        private final Consumer<CleanerThread> onShutdown;

        public CleanerThread(Consumer<CleanerThread> onShutdown) {
            this.setName(ReferenceCleaner.class.getName());
            this.setDaemon(true);
            this.onShutdown = onShutdown;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            block7: while (true) {
                while (!ReferenceCleaner.this.createdReferences.isEmpty() && !Thread.interrupted()) {
                    try {
                        Reference ref = (Reference)ReferenceCleaner.this.referenceQueue.remove();
                        if (ref == null || !ReferenceCleaner.this.createdReferences.remove(ref)) continue block7;
                        ref.cleaner.accept(ref, ref.meta);
                    }
                    catch (InterruptedException thr) {
                        log.debug("ReferenceCleaner thread interrupted.", (Throwable)thr);
                        this.onShutdown.accept(this);
                        return;
                    }
                    catch (Exception thr) {
                        try {
                            log.error("ReferenceCleaner cleaning thread failed", (Throwable)thr);
                            continue block7;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                            return;
                        }
                    }
                }
            }
            finally {
                this.onShutdown.accept(this);
            }
        }
    }

    private final class Reference<ReferentType, MetaType>
    extends WeakReference<ReferentType>
    implements CleanableWeakReference<ReferentType> {
        private final MetaType meta;
        private final BiConsumer<CleanableWeakReference<ReferentType>, MetaType> cleaner;

        private Reference(ReferentType referent, MetaType meta, BiConsumer<CleanableWeakReference<ReferentType>, MetaType> cleaner, ReferenceQueue<ReferentType> referenceQueue) {
            super(referent, referenceQueue);
            this.meta = meta;
            this.cleaner = cleaner;
        }

        @Override
        public boolean cancelCleaningOrder() {
            return ReferenceCleaner.this.createdReferences.remove(this);
        }
    }
}

