/*
 * Decompiled with CFR 0.152.
 */
package ru.mail.libverify.api;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresPermission;
import android.support.annotation.WorkerThread;
import android.text.TextUtils;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public interface VerificationApi {
    public String startVerification(@NonNull String var1, @NonNull String var2, @Nullable String var3, @Nullable Map<String, String> var4);

    public void cancelVerification(@NonNull String var1);

    public void cancelVerification(@NonNull String var1, CancelReason var2);

    public void requestGcmToken(@NonNull GcmTokenListener var1);

    public void completeVerification(@NonNull String var1);

    public void verifySmsCode(@NonNull String var1, @NonNull String var2);

    public void reportNetworkStateChange(boolean var1);

    public void addVerificationStateChangedListener(@NonNull VerificationStateChangedListener var1);

    public void removeVerificationStateChangedListener(@NonNull VerificationStateChangedListener var1);

    public void addSmsCodeNotificationListener(@NonNull SmsCodeNotificationListener var1);

    public void removeSmsCodeNotificationListener(@NonNull SmsCodeNotificationListener var1);

    public void requestVerificationStates(@NonNull VerificationStatesHandler var1);

    public void requestVerificationState(@NonNull String var1, @NonNull VerificationStateChangedListener var2);

    public void resetVerificationCodeError(@NonNull String var1);

    public void reset();

    public void signOut(boolean var1);

    public void softSignOut();

    public void prepare2StepAuthCheck();

    public void checkAccountVerification(@NonNull String var1);

    public void checkAccountVerificationBySms(@NonNull String var1, @Nullable AccountCheckListener var2);

    public void requestIvrPhoneCall(@NonNull String var1, IvrStateListener var2);

    public void checkPhoneNumber(@NonNull String var1, @NonNull String var2, @NonNull String var3, boolean var4, @NonNull PhoneCheckListener var5);

    public void setCustomLocale(@NonNull Locale var1);

    public void setSimDataSendDisabled(boolean var1);

    public void setLocationUsage(boolean var1);

    public void requestNewSmsCode(@NonNull String var1);

    @RequiresPermission(allOf={"android.permission.GET_ACCOUNTS", "android.permission.READ_PHONE_STATE"})
    public void searchPhoneAccounts(@NonNull PhoneAccountSearchListener var1, boolean var2);

    public void setAllowedPermissions(@NonNull String[] var1);

    public void setApiEndpoints(@NonNull Map<String, String> var1);

    public void querySmsDialogs(@NonNull SmsDialogsListener var1);

    public void querySms(@Nullable String var1, @Nullable Long var2, @Nullable Long var3, @Nullable Integer var4, @NonNull SmsListener var5);

    public void removeSmsDialog(@Nullable String var1, @Nullable Long var2);

    public void removeSms(@NonNull String var1, @Nullable Long var2, long var3);

    public void clearSmsDialogs();

    public void addSmsDialogChangedListener(@NonNull SmsDialogChangedListener var1);

    public void removeSmsDialogChangedListener(@NonNull SmsDialogChangedListener var1);

    public static interface GcmTokenListener {
        @WorkerThread
        public void onReceived(@Nullable String var1);
    }

    public static enum CancelReason {
        TOKEN_SWAP_GENERAL_ERROR,
        TOKEN_SWAP_NETWORK_ERROR,
        CANCELLED_BY_USER,
        PHONE_EDIT_BY_USER,
        GENERAL_ERROR,
        OK;

    }

    public static interface SmsDialogChangedListener {
        @WorkerThread
        public void onChanged(@Nullable SmsDialogItem var1);
    }

    public static interface SmsListener {
        @WorkerThread
        public void onCompleted(@NonNull List<SmsItem> var1);

        @WorkerThread
        public void onError();
    }

    public static interface SmsDialogsListener {
        @WorkerThread
        public void onCompleted(@NonNull List<SmsDialogItem> var1);

        @WorkerThread
        public void onError();
    }

    public static interface SmsDialogItem
    extends Comparable<SmsDialogItem> {
        public long getId();

        public String getFrom();

        public long getLastTimestamp();

        public String getLastText();

        public boolean hasUnread();
    }

    public static interface SmsItem {
        public long getId();

        public String getText();

        public long getTimestamp();

        public String getFrom();
    }

    public static class VerificationStateDescriptor {
        private VerificationState a = VerificationState.INITIAL;
        private VerificationSource b = VerificationSource.UNKNOWN;
        private FailReason c = FailReason.OK;
        private boolean d = false;
        @Nullable
        private String e;
        @Nullable
        private String f;
        private String g;
        private int h;
        private SmsCodeInfo i;
        private IvrInfo j;
        private Map<String, String> k;

        public VerificationStateDescriptor(VerificationState verificationState, VerificationSource verificationSource, FailReason failReason, boolean bl, @Nullable String string2, @Nullable String string3, String string4, int n2, int n3, boolean bl2, String string5, Set<String> set, int n4, Map<String, String> map, boolean bl3) {
            this.e = string2;
            this.b = verificationSource;
            this.c = failReason;
            this.g = string4;
            this.h = n2;
            this.a = verificationState;
            this.i = new SmsCodeInfo(n3, bl2, string5);
            this.j = new IvrInfo(set, n4, bl3);
            this.k = map;
            this.f = string3;
        }

        public VerificationStateDescriptor(VerificationState verificationState, FailReason failReason, boolean bl) {
            this.d = bl;
            this.a = verificationState;
            this.c = failReason;
        }

        public VerificationStateDescriptor(VerificationState verificationState, boolean bl) {
            this.d = bl;
            this.a = verificationState;
        }

        public VerificationState getState() {
            return this.a;
        }

        public FailReason getReason() {
            return this.c;
        }

        @Nullable
        public String getModifiedPhoneNumber() {
            return this.e;
        }

        @Nullable
        public String getUserId() {
            return this.f;
        }

        public String getToken() {
            return this.g;
        }

        public int getTokenExpirationTimeoutSec() {
            return this.h;
        }

        public Map<String, String> getAppEndpoints() {
            return this.k;
        }

        public VerificationSource getSource() {
            return this.b;
        }

        public SmsCodeInfo getSmsCodeInfo() {
            return this.i;
        }

        public IvrInfo getIvrInfo() {
            return this.j;
        }

        public boolean completedSuccessfully() {
            return (this.a == VerificationState.FINAL || this.a == VerificationState.SUCCEEDED) && this.c == FailReason.OK && !TextUtils.isEmpty((CharSequence)this.g);
        }

        public boolean isVerifiedOnce() {
            return this.d;
        }

        public String toString() {
            return "VerificationStateDescriptor{state='" + (Object)((Object)this.a) + '\'' + ", source='" + (Object)((Object)this.b) + '\'' + ", reason='" + (Object)((Object)this.c) + '\'' + ", modifiedPhoneNumber='" + this.e + '\'' + ", token='" + this.g + '\'' + ", smsCodeInfo='" + this.i + '\'' + ", ivrInfo='" + this.j + '\'' + ", appEndpoints='" + this.k + '\'' + '}';
        }

        public class IvrInfo {
            public final Set<String> supportedIvrLanguages;
            public final int ivrTimeoutSec;
            public final boolean defaultIvrTimeoutApplied;

            IvrInfo(Set<String> set, int n2, boolean bl) {
                this.supportedIvrLanguages = set;
                this.ivrTimeoutSec = n2;
                this.defaultIvrTimeoutApplied = bl;
            }

            public String toString() {
                return "IvrInfo{supportedIvrLanguages=" + this.supportedIvrLanguages + ", ivrTimeoutSec=" + this.ivrTimeoutSec + ", defaultIvrTimeoutApplied=" + this.defaultIvrTimeoutApplied + '}';
            }
        }

        public class SmsCodeInfo {
            public final int smsCodeLength;
            public final boolean isNumericSmsCode;
            public final String receivedSmsCode;

            SmsCodeInfo(int n2, boolean bl, String string2) {
                this.smsCodeLength = n2;
                this.isNumericSmsCode = bl;
                this.receivedSmsCode = string2;
            }

            public String toString() {
                return "SmsCodeInfo{smsCodeLength=" + this.smsCodeLength + ", isNumericSmsCode=" + this.isNumericSmsCode + '}';
            }
        }
    }

    public static enum AccountCheckResult {
        OK,
        NO_SMS_PERMISSION,
        NO_SMS_FOUND,
        NO_SMS_FOUND_HAS_SOURCE_MATCH,
        NO_SMS_FOUND_HAS_CODE,
        NO_SMS_INFO,
        EMPTY_ACCOUNT_DATA,
        GENERAL_ERROR;

    }

    public static interface AccountCheckListener {
        @WorkerThread
        public void onComplete(AccountCheckResult var1);
    }

    public static interface PhoneAccountSearchListener {
        @WorkerThread
        public void onComplete(@NonNull List<PhoneAccountSearchItem> var1);
    }

    public static class PhoneAccountSearchItem {
        public final String phone;
        public final String source;

        PhoneAccountSearchItem(String string2, String string3) {
            this.phone = string2;
            this.source = string3;
        }
    }

    public static class PhoneNumberCheckSession {
        private static final Random a = new Random();
        private final String b;
        private final VerificationApi c;

        public PhoneNumberCheckSession(@NonNull VerificationApi verificationApi) {
            this.c = verificationApi;
            this.b = Integer.toString(a.nextInt());
        }

        public PhoneNumberCheckSession(@NonNull VerificationApi verificationApi, @NonNull String string2) {
            this.c = verificationApi;
            this.b = string2;
        }

        public String getId() {
            return this.b;
        }

        public void checkPhoneNumber(@NonNull String string2, @NonNull String string3, boolean bl, @NonNull PhoneCheckListener phoneCheckListener) {
            this.c.checkPhoneNumber(this.b, string2, string3, bl, phoneCheckListener);
        }
    }

    public static interface PhoneCheckResult {
        public FailReason getReason();

        public State getState();

        public boolean isValid();

        public boolean isUnknown();

        public boolean isInvalid();

        public boolean isWarning();

        public String[] getPrintableText();

        public ExtendedInfo getExtendedInfo();

        public boolean isApproximate();

        public static enum State {
            VALID,
            INVALID,
            UNKNOWN;

        }

        public static interface ExtendedInfo {
            public boolean isMobile();

            public boolean isFixedLine();

            public Integer getRemainingLength();

            public String getModifiedPhoneNumber();

            public String getModifiedPrefix();
        }
    }

    public static interface PhoneCheckListener {
        @WorkerThread
        public void onCompleted(@NonNull String var1, @NonNull PhoneCheckResult var2);
    }

    public static interface IvrStateListener {
        @WorkerThread
        public void onRequestExecuted(FailReason var1);
    }

    public static enum FailReason {
        OK,
        GENERAL_ERROR,
        UNSUPPORTED_NUMBER,
        INCORRECT_PHONE_NUMBER,
        INCORRECT_SMS_CODE,
        RATELIMIT,
        NETWORK_ERROR,
        NO_NETWORK;

        String description;

        public final String getDescription() {
            return this.description;
        }
    }

    public static interface VerificationStateChangedListener {
        @WorkerThread
        public void onStateChanged(@NonNull String var1, @Nullable VerificationStateDescriptor var2);
    }

    public static interface SmsCodeNotificationListener {
        @WorkerThread
        public void onNotification(@NonNull String var1);
    }

    public static enum VerificationSource {
        UNKNOWN,
        SMS,
        CALL,
        SMS_RETRIEVER,
        USER_INPUT,
        ALREADY_VERIFIED,
        APPLICATION_LOCAL,
        APPLICATION_EXTERNAL;

    }

    public static enum VerificationState {
        INITIAL,
        VERIFYING_PHONE_NUMBER,
        WAITING_FOR_SMS_CODE,
        VERIFYING_SMS_CODE,
        SUCCEEDED,
        FAILED,
        SUSPENDED,
        FINAL;

    }

    public static interface VerificationStatesHandler {
        public void onExistingVerificationsFound(List<String> var1);
    }
}

