/*
 * Decompiled with CFR 0.152.
 */
package ru.mail.libverify.api;

import android.content.Context;
import android.os.Bundle;
import android.os.Message;
import android.support.annotation.NonNull;
import dagger.internal.Preconditions;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Executors;
import ru.mail.libverify.api.VerificationApi;
import ru.mail.libverify.api.f;
import ru.mail.libverify.api.g;
import ru.mail.libverify.api.n;
import ru.mail.libverify.api.q;
import ru.mail.notify.core.R;
import ru.mail.notify.core.api.ApiComponent;
import ru.mail.notify.core.api.ApplicationModule;
import ru.mail.notify.core.api.InternalFactory;
import ru.mail.notify.core.api.UncaughtExceptionListener;
import ru.mail.notify.core.storage.Installation;
import ru.mail.notify.core.utils.AlarmReceiver;
import ru.mail.notify.core.utils.DebugFileLogImpl;
import ru.mail.notify.core.utils.FileLog;
import ru.mail.notify.core.utils.LogReceiver;
import ru.mail.notify.core.utils.SocketFactoryProvider;
import ru.mail.notify.core.utils.components.BusMessageType;
import ru.mail.notify.core.utils.components.MessageBusUtils;

public final class VerificationFactory {
    public static final String LIBVERIFY_RESOURCE_APPLICATION_NAME_KEY = "libverify_application_name";
    public static final String LIBVERIFY_MANIFEST_APPLICATION_NAME_KEY = "ru.mail.libverify.application_name";
    public static final String LIBVERIFY_RESOURCE_APPLICATION_KEY_KEY = "libverify_application_key";
    public static final String LIBVERIFY_MANIFEST_APPLICATION_KEY_KEY = "ru.mail.libverify.application_key";
    public static final String LIBVERIFY_MANIFEST_SERVER_ID_KEY = "ru.mail.libverify.server_id";
    public static final String LIBVERIFY_RESOURCE_SERVER_ID_KEY = "libverify_server_id";
    public static final String LIBVERIFY_DIRECT_PUSH_BROADCAST_ACTION = "ru.mail.libverify.direct_push";
    public static final String LIBVERIFY_GCM_TOKEN_BROADCAST_ACTION = "ru.mail.libverify.gcm_token";
    public static final String LIBVERIFY_DIRECT_PUSH_PAYLOAD_KEY = "direct_push_payload";
    public static final String LIBVERIFY_DIRECT_PUSH_ID_KEY = "direct_push_id";
    public static final String LIBVERIFY_GCM_TOKEN = "gcm_token";
    private static volatile q a;

    @NonNull
    public static VerificationApi get(@NonNull Context context) {
        return VerificationFactory.b(context).a();
    }

    public static void initialize(final @NonNull Context context) {
        if (a != null) {
            throw new IllegalStateException("initialize() must be called once before any other libverify method calls");
        }
        FileLog.init((LogReceiver)new DebugFileLogImpl(context));
        InternalFactory.addInitializer((Runnable)new Runnable(){

            @Override
            public final void run() {
                VerificationFactory.b(context).a();
            }
        });
    }

    public static void bootstrap(@NonNull Context context) {
        InternalFactory.bootstrap((Context)context);
    }

    public static void enableDebugMode() {
        InternalFactory.getAppModule().setDebugMode();
    }

    public static void setLogReceiver(@NonNull LogReceiver logReceiver) {
        InternalFactory.getAppModule().setLogReceiver(logReceiver);
    }

    public static void setUncaughtExceptionListener(@NonNull UncaughtExceptionListener uncaughtExceptionListener) {
        InternalFactory.getAppModule().setUncaughtExceptionListener(uncaughtExceptionListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static q b(@NonNull Context object) {
        if (a != null) return a;
        Class<InternalFactory> clazz = InternalFactory.class;
        synchronized (InternalFactory.class) {
            if (a != null) return a;
            object = InternalFactory.getCommonApi((Context)object);
            ApplicationModule applicationModule = InternalFactory.getAppModule();
            Object object2 = object;
            object = new f.a(0);
            new f.a(0).b = (ApiComponent)Preconditions.checkNotNull((Object)object2);
            object2 = applicationModule;
            v0.a = (ApplicationModule)Preconditions.checkNotNull((Object)object2);
            if (object.a == null) {
                object.a = new ApplicationModule();
            }
            if (object.b == null) {
                throw new IllegalStateException(ApiComponent.class.getCanonicalName() + " must be set");
            }
            a = new f((f.a)object, 0);
            // ** MonitorExit[var1_2] (shouldn't be in output)
            return a;
        }
    }

    @NonNull
    public static VerificationApi getInstance(@NonNull Context context) {
        return VerificationFactory.get(context);
    }

    public static boolean hasInstallation(@NonNull Context context) {
        return Installation.hasInstallation((Context)context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void release(@NonNull Context context) {
        if (a != null) {
            Class<InternalFactory> clazz = InternalFactory.class;
            synchronized (InternalFactory.class) {
                if (a != null) {
                    InternalFactory.post((Context)context, (Message)MessageBusUtils.createOneArg((BusMessageType)BusMessageType.API_SHUTDOWN, null));
                    a = null;
                }
                // ** MonitorExit[var1_2] (shouldn't be in output)
                return;
            }
        }
    }

    @NonNull
    public static String[] getRequiredPermissions() {
        return n.b();
    }

    @NonNull
    public static String getGcmServerId(@NonNull Context context) {
        return context.getResources().getString(R.string.libverify_server_id);
    }

    public static void deliverGcmMessageIntent(@NonNull Context context, String string2, Bundle bundle) {
        InternalFactory.deliverGcmMessageIntent((Context)context, (String)string2, (Bundle)bundle);
    }

    public static void deliverGcmMessageIntent(@NonNull Context context, String string2, Map<String, String> map) {
        InternalFactory.deliverGcmMessageIntent((Context)context, (String)string2, map);
    }

    public static void refreshGcmToken(@NonNull Context context) {
        InternalFactory.refreshGcmToken((Context)context);
    }

    @Deprecated
    public static void onAppCreated(final @NonNull Context context) {
        Executors.newCachedThreadPool().submit(new Runnable(){

            @Override
            public final void run() {
                if (!VerificationFactory.hasInstallation(context)) {
                    return;
                }
                AlarmReceiver.create((Context)context, (boolean)false).setTimeout(600000L).setAction(BusMessageType.SERVICE_SETTINGS_CHECK.name()).putExtra("settings_action_type", g.a.RESTART.name()).disableRandomShift().setUp();
            }
        });
    }

    public static void signOut(@NonNull Context context, boolean bl) {
        if (!VerificationFactory.hasInstallation(context)) {
            return;
        }
        VerificationFactory.get(context).signOut(bl);
    }

    public static void softSignOut(@NonNull Context context) {
        if (!VerificationFactory.hasInstallation(context)) {
            return;
        }
        VerificationFactory.get(context).softSignOut();
    }

    public static void setCustomLocale(@NonNull Context context, @NonNull Locale locale) {
        VerificationFactory.get(context).setCustomLocale(locale);
    }

    public static void setDisableSimDataSend(@NonNull Context context, boolean bl) {
        VerificationFactory.get(context).setSimDataSendDisabled(bl);
    }

    public static void setLocationUsage(@NonNull Context context, boolean bl) {
        VerificationFactory.get(context).setLocationUsage(bl);
    }

    public static void setApiEndpoints(@NonNull Context context, @NonNull Map<String, String> map) {
        VerificationFactory.get(context).setApiEndpoints(map);
    }

    public static void setSocketFactoryProvider(@NonNull SocketFactoryProvider socketFactoryProvider) {
        InternalFactory.getAppModule().setSocketFactoryProvider(socketFactoryProvider);
    }
}

