/*
 * Decompiled with CFR 0.152.
 */
package ru.mail.libverify.notifications;

import android.app.IntentService;
import android.content.Context;
import android.content.Intent;
import android.os.Message;
import android.text.TextUtils;
import java.util.Locale;
import ru.mail.notify.core.api.InternalFactory;
import ru.mail.notify.core.utils.DebugUtils;
import ru.mail.notify.core.utils.FileLog;
import ru.mail.notify.core.utils.components.BusMessageType;
import ru.mail.notify.core.utils.components.MessageBusUtils;

public class NotificationService
extends IntentService {
    public NotificationService() {
        super("NotificationService");
    }

    protected void onHandleIntent(Intent object) {
        if (object == null) {
            return;
        }
        String string2 = object.getAction();
        if (TextUtils.isEmpty((CharSequence)string2)) {
            FileLog.e((String)"NotificationService", (String)"Wrong action type detected");
            return;
        }
        object = object.getStringExtra("notification_id");
        FileLog.v((String)"NotificationService", (String)"received extra %s from notification %s", (Object[])new Object[]{string2, object});
        switch (string2) {
            case "action_delete": 
            case "action_cancel": {
                InternalFactory.postAndWait((Context)this, (Message)MessageBusUtils.createOneArg((BusMessageType)BusMessageType.SERVICE_NOTIFICATION_CANCEL, (Object)object));
                return;
            }
            case "action_confirm": {
                InternalFactory.postAndWait((Context)this, (Message)MessageBusUtils.createOneArg((BusMessageType)BusMessageType.SERVICE_NOTIFICATION_CONFIRM, (Object)object));
                return;
            }
        }
        DebugUtils.safeThrow((String)"NotificationService", (String)"wrong action type", (Throwable)new IllegalArgumentException(String.format(Locale.US, "Wrong action type %s for NotificationService detected", string2)));
    }
}

