/*
 * Decompiled with CFR 0.152.
 */
package ru.mail.libverify.sms;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.os.Message;
import android.support.annotation.NonNull;
import android.support.v4.app.NotifySafeJobIntentService;
import android.telephony.SmsMessage;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import ru.mail.libverify.R;
import ru.mail.notify.core.api.InternalFactory;
import ru.mail.notify.core.utils.DebugUtils;
import ru.mail.notify.core.utils.FileLog;
import ru.mail.notify.core.utils.Utils;
import ru.mail.notify.core.utils.components.BusMessageType;
import ru.mail.notify.core.utils.components.MessageBusUtils;

public class SmsHandlingService
extends NotifySafeJobIntentService {
    public void onDestroy() {
        super.onDestroy();
        FileLog.v((String)"SmsHandlingService", (String)"service destroyed");
    }

    protected void onHandleWork(@NonNull Intent object) {
        if (object.getExtras() == null) {
            FileLog.e((String)"SmsHandlingService", (String)"Incoming intent extras is null");
            return;
        }
        try {
            if (object.hasExtra("pdus")) {
                int n2;
                Object object2;
                SmsMessage[] smsMessageArray;
                FileLog.v((String)"SmsHandlingService", (String)"Incoming sms dump %s", (Object[])new Object[]{Utils.bundleToString((Bundle)object.getExtras())});
                Object object3 = object;
                object = this;
                try {
                    smsMessageArray = object3;
                    object2 = (Object[])smsMessageArray.getSerializableExtra("pdus");
                    smsMessageArray = smsMessageArray.getStringExtra("format");
                    n2 = ((Object[])object2).length;
                    SmsMessage[] smsMessageArray2 = new SmsMessage[n2];
                    for (int i2 = 0; i2 < n2; ++i2) {
                        byte[] byArray = (byte[])object2[i2];
                        smsMessageArray2[i2] = Build.VERSION.SDK_INT >= 23 && !TextUtils.isEmpty((CharSequence)smsMessageArray) ? SmsMessage.createFromPdu((byte[])byArray, (String)smsMessageArray) : SmsMessage.createFromPdu((byte[])byArray);
                    }
                    smsMessageArray = smsMessageArray2;
                }
                catch (Throwable throwable) {
                    FileLog.e((String)"SmsHandlingService", (String)"can't parse sms message %s", (Object[])new Object[]{throwable.getMessage()});
                    object3.removeExtra("pdus");
                    DebugUtils.safeThrow((String)"SmsHandlingService", (String)"handleSmsMessages", (Throwable)new RuntimeException(new RuntimeException("intent : " + Utils.bundleToString((Bundle)object3.getExtras()), throwable)));
                    return;
                }
                if (n2 <= 0) {
                    FileLog.e((String)"SmsHandlingService", (String)"received message is empty");
                    return;
                }
                object2 = smsMessageArray[0].getDisplayOriginatingAddress();
                object3 = SmsHandlingService.a(smsMessageArray);
                if (TextUtils.isEmpty((CharSequence)object2) || TextUtils.isEmpty((CharSequence)object3)) {
                    FileLog.e((String)"SmsHandlingService", (String)"received ether message or phoneNumber is empty");
                    return;
                }
                FileLog.v((String)"SmsHandlingService", (String)"received message");
                InternalFactory.postAndWait((Context)object, (Message)MessageBusUtils.createMultipleArgs((BusMessageType)BusMessageType.SERVICE_SMS_RECEIVED, (Object[])new Object[]{object2, object3}));
                return;
            }
            if (object.hasExtra("state") && TextUtils.equals((CharSequence)object.getStringExtra("state"), (CharSequence)TelephonyManager.EXTRA_STATE_RINGING)) {
                String string;
                Intent intent = object;
                object = this;
                FileLog.v((String)"SmsHandlingService", (String)"received call");
                if (intent.getExtras() != null && !TextUtils.isEmpty((CharSequence)(string = intent.getExtras().getString("incoming_number")))) {
                    InternalFactory.postAndWait((Context)object, (Message)MessageBusUtils.createOneArg((BusMessageType)BusMessageType.SERVICE_CALL_RECEIVED, (Object)string));
                }
                return;
            }
            FileLog.v((String)"SmsHandlingService", (String)"empty intent");
            return;
        }
        catch (Throwable throwable) {
            FileLog.e((String)"SmsHandlingService", (String)"failed to process incoming sms %s", (Object[])new Object[]{throwable.getMessage()});
            return;
        }
    }

    static void a(@NonNull Context context, @NonNull Intent intent) {
        try {
            int n2 = context.getResources().getInteger(R.integer.libnotify_sms_call_job_id);
            SmsHandlingService.enqueueWork((Context)context.getApplicationContext(), SmsHandlingService.class, (int)n2, (Intent)intent);
            return;
        }
        catch (Throwable throwable) {
            FileLog.e((String)"SmsHandlingService", (String)"failed to start a service", (Throwable)throwable);
            return;
        }
    }

    private static String a(SmsMessage[] smsMessageArray) {
        StringBuilder stringBuilder = new StringBuilder(160);
        for (SmsMessage smsMessage : smsMessageArray) {
            stringBuilder.append(smsMessage.getMessageBody());
        }
        return stringBuilder.toString();
    }
}

