/*
 * Decompiled with CFR 0.152.
 */
package ru.mail.libverify.storage;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.support.annotation.NonNull;
import android.telephony.CellInfo;
import android.telephony.CellInfoCdma;
import android.telephony.CellInfoGsm;
import android.telephony.CellInfoLte;
import android.telephony.CellInfoWcdma;
import android.telephony.CellSignalStrengthGsm;
import android.telephony.TelephonyManager;
import org.json.JSONObject;
import ru.mail.libverify.storage.h;
import ru.mail.notify.core.accounts.SimCardData;
import ru.mail.notify.core.accounts.SimCardItem;
import ru.mail.notify.core.storage.InstanceConfig;
import ru.mail.notify.core.utils.FileLog;
import ru.mail.notify.core.utils.Utils;

final class d {
    static String a(@NonNull h object) {
        System.currentTimeMillis();
        try {
            JSONObject jSONObject = new JSONObject();
            Integer n2 = Utils.getBatteryLevel((Context)object.getContext());
            if (n2 != null) {
                jSONObject.put("batteryLevel", (Object)n2);
            }
            jSONObject.put("defaultLocale", (Object)Utils.getCurrentLocaleUnixId());
            n2 = new JSONObject();
            n2.put("manufacturer", Build.MANUFACTURER);
            n2.put("model", Build.MODEL);
            jSONObject.put("device", (Object)n2);
            jSONObject.put("deviceId", (Object)Utils.stringToSHA256((String)object.getStringProperty(InstanceConfig.PropertyType.SYSTEM_ID)));
            n2 = new JSONObject();
            Boolean bl = Utils.isVoiceCapable((Context)object.getContext());
            if (bl != null) {
                n2.put("isVoiceCapable", bl);
            }
            if ((bl = Utils.isRoaming((Context)object.getContext())) != null) {
                n2.put("roaming", bl);
            }
            n2.put("cellular", d.b(object.getContext()));
            n2.put("data", d.a(object.getContext()));
            jSONObject.put("networkInfo", (Object)n2);
            jSONObject.put("os", (Object)Build.VERSION.RELEASE);
            n2 = new JSONObject();
            n2.put("ACCESS_NETWORK_STATE", Utils.hasSelfPermission((Context)object.getContext(), (String)"android.permission.ACCESS_NETWORK_STATE"));
            n2.put("CALL_PHONE", Utils.hasSelfPermission((Context)object.getContext(), (String)"android.permission.CALL_PHONE"));
            if (Build.VERSION.SDK_INT >= 16) {
                n2.put("READ_CALL_LOG", Utils.hasSelfPermission((Context)object.getContext(), (String)"android.permission.READ_CALL_LOG"));
            }
            n2.put("READ_PHONE_STATE", Utils.hasSelfPermission((Context)object.getContext(), (String)"android.permission.READ_PHONE_STATE"));
            n2.put("READ_SMS", Utils.hasSelfPermission((Context)object.getContext(), (String)"android.permission.READ_SMS"));
            n2.put("RECEIVE_SMS", Utils.hasSelfPermission((Context)object.getContext(), (String)"android.permission.RECEIVE_SMS"));
            n2.put("getCellularSignalLevel", Utils.hasSelfPermission((Context)object.getContext(), (String)"android.permission.ACCESS_COARSE_LOCATION") || Utils.hasSelfPermission((Context)object.getContext(), (String)"android.permission.ACCESS_FINE_LOCATION"));
            jSONObject.put("permissions", (Object)n2);
            n2 = object.k();
            jSONObject.put("simCardsCount", n2.size());
            jSONObject.put("simCardsInfo", (Object)d.a(object.getContext(), (SimCardData)n2));
            jSONObject.put("platform", (Object)"Android");
            object = jSONObject.toString();
            return object;
        }
        catch (Throwable throwable) {
            FileLog.e((String)"ExtendedPhoneInfo", (String)"failed to build extended info", (Throwable)throwable);
            return null;
        }
    }

    private static JSONObject a(@NonNull Context context, @NonNull SimCardData object) {
        JSONObject jSONObject = new JSONObject();
        try {
            if (!Utils.hasSelfPermission((Context)context, (String)"android.permission.READ_PHONE_STATE")) {
                return jSONObject;
            }
            int n2 = 1;
            object = object.iterator();
            while (object.hasNext()) {
                SimCardItem simCardItem = (SimCardItem)object.next();
                JSONObject jSONObject2 = new JSONObject();
                JSONObject jSONObject3 = new JSONObject();
                jSONObject3.put("countryId", (Object)simCardItem.getNetworkCountryIso());
                jSONObject3.put("mcc", (Object)simCardItem.getNetworkMCC());
                jSONObject3.put("mnc", (Object)simCardItem.getNetworkMNC());
                jSONObject3.put("name", (Object)simCardItem.getNetworkOperatorName());
                jSONObject3.put("roaming", simCardItem.isNetworkRoaming());
                JSONObject jSONObject4 = new JSONObject();
                jSONObject4.put("countryId", (Object)simCardItem.getSimCountryIso());
                jSONObject4.put("mcc", (Object)simCardItem.getOperatorMCC());
                jSONObject4.put("mnc", (Object)simCardItem.getOperatorMNC());
                jSONObject4.put("name", (Object)simCardItem.getOperatorName());
                jSONObject2.put("operator", (Object)jSONObject3);
                jSONObject2.put("sim", (Object)jSONObject4);
                jSONObject.put(Integer.toString(n2), (Object)jSONObject2);
                ++n2;
            }
        }
        catch (Throwable throwable) {
            FileLog.e((String)"ExtendedPhoneInfo", (String)"failed to get sim card info", (Throwable)throwable);
        }
        return jSONObject;
    }

    private static JSONObject a(@NonNull Context networkInfoArray) {
        JSONObject jSONObject = new JSONObject();
        try {
            if (!Utils.hasSelfPermission((Context)networkInfoArray, (String)"android.permission.ACCESS_NETWORK_STATE")) {
                return jSONObject;
            }
            String string2 = "Not connected";
            if ((networkInfoArray = (ConnectivityManager)networkInfoArray.getSystemService("connectivity")) != null) {
                NetworkInfo networkInfo = networkInfoArray.getActiveNetworkInfo();
                if (networkInfo != null && networkInfo.isConnected()) {
                    string2 = networkInfo.getTypeName();
                } else {
                    for (NetworkInfo networkInfo2 : networkInfoArray.getAllNetworkInfo()) {
                        if (!networkInfo2.isConnected()) continue;
                        string2 = networkInfo2.getTypeName();
                        break;
                    }
                }
                jSONObject.put("type", (Object)string2);
            }
        }
        catch (Throwable throwable) {
            FileLog.e((String)"ExtendedPhoneInfo", (String)"failed to get data info", (Throwable)throwable);
        }
        return jSONObject;
    }

    private static JSONObject b(@NonNull Context object) {
        JSONObject jSONObject = new JSONObject();
        try {
            if (!Utils.hasSelfPermission((Context)object, (String)"android.permission.ACCESS_COARSE_LOCATION") && !Utils.hasSelfPermission((Context)object, (String)"android.permission.ACCESS_FINE_LOCATION")) {
                return jSONObject;
            }
            if (Build.VERSION.SDK_INT >= 17 && (object = (TelephonyManager)object.getSystemService("phone")) != null && (object = object.getAllCellInfo()) != null) {
                int n2 = 1;
                object = object.iterator();
                while (object.hasNext()) {
                    CellInfo cellInfo = (CellInfo)object.next();
                    if (!cellInfo.isRegistered()) continue;
                    CellSignalStrengthGsm cellSignalStrengthGsm = null;
                    String string2 = "Unknown";
                    JSONObject jSONObject2 = new JSONObject();
                    if (cellInfo instanceof CellInfoGsm) {
                        cellSignalStrengthGsm = ((CellInfoGsm)cellInfo).getCellSignalStrength();
                        string2 = "Gsm";
                    } else if (cellInfo instanceof CellInfoCdma) {
                        cellSignalStrengthGsm = ((CellInfoCdma)cellInfo).getCellSignalStrength();
                        string2 = "Cdma";
                    } else if (cellInfo instanceof CellInfoLte) {
                        cellSignalStrengthGsm = ((CellInfoLte)cellInfo).getCellSignalStrength();
                        string2 = "Lte";
                    } else if (cellInfo instanceof CellInfoWcdma) {
                        if (Build.VERSION.SDK_INT >= 18) {
                            cellSignalStrengthGsm = ((CellInfoWcdma)cellInfo).getCellSignalStrength();
                        }
                        string2 = "Wcdma";
                    }
                    jSONObject2.put("type", (Object)string2);
                    jSONObject2.put("signalLevel", cellSignalStrengthGsm == null ? -1 : cellSignalStrengthGsm.getLevel());
                    jSONObject.put(Integer.toString(n2), (Object)jSONObject2);
                    ++n2;
                }
            }
        }
        catch (Throwable throwable) {
            FileLog.e((String)"ExtendedPhoneInfo", (String)"failed to get cell info", (Throwable)throwable);
        }
        return jSONObject;
    }
}

