/*
 * Decompiled with CFR 0.152.
 */
package ru.mail.libverify.storage;

import android.support.annotation.NonNull;
import android.text.TextUtils;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import ru.mail.libverify.storage.DecryptionError;
import ru.mail.notify.core.storage.KeyValueStorage;
import ru.mail.notify.core.utils.DebugUtils;
import ru.mail.notify.core.utils.FileLog;
import ru.mail.notify.core.utils.PRNGFixes;
import ru.mail.notify.core.utils.Utils;

final class l {
    private final KeyValueStorage a;

    l(KeyValueStorage keyValueStorage) {
        this.a = keyValueStorage;
    }

    final synchronized String a() {
        Object object = this.a.getValue("server_key_manager_private_data");
        Object object2 = this.a.getValue("server_key_manager_public_data");
        if (TextUtils.isEmpty((CharSequence)object2) || TextUtils.isEmpty((CharSequence)object)) {
            try {
                FileLog.v((String)"ServerKeyManager", (String)"key generation started");
                PRNGFixes.apply();
                object = KeyPairGenerator.getInstance("RSA");
                ((KeyPairGenerator)object).initialize(2048);
                object2 = ((KeyPairGenerator)object).generateKeyPair();
                FileLog.v((String)"ServerKeyManager", (String)"key generation completed");
            }
            catch (InvalidAlgorithmParameterException | NoSuchAlgorithmException generalSecurityException) {
                FileLog.e((String)"ServerKeyManager", (String)"failed to generate key pair", (Throwable)generalSecurityException);
                return null;
            }
            object = Utils.getBase64String((byte[])((KeyPair)object2).getPrivate().getEncoded());
            object2 = Utils.getBase64String((byte[])((KeyPair)object2).getPublic().getEncoded());
            this.a.putValue("server_key_manager_private_data", (String)object).putValue("server_key_manager_public_data", (String)object2).commit();
        }
        return object2;
    }

    final synchronized String a(@NonNull String object, @NonNull String object2) {
        FileLog.v((String)"ServerKeyManager", (String)"decrypt message started");
        if (TextUtils.isEmpty((CharSequence)object) || TextUtils.isEmpty((CharSequence)object2)) {
            throw new IllegalArgumentException();
        }
        Object object3 = this.a.getValue("server_key_manager_private_data");
        if (TextUtils.isEmpty((CharSequence)object3)) {
            throw new DecryptionError("No private key found");
        }
        try {
            byte[] byArray = Utils.decodeBase64FromString((String)object3);
            object3 = byArray;
            if (byArray == null) {
                throw new IllegalStateException("Failed to extract encoded key");
            }
            object3 = new PKCS8EncodedKeySpec((byte[])object3);
            object3 = KeyFactory.getInstance("RSA").generatePrivate((KeySpec)object3);
            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1PADDING");
            cipher.init(2, (Key)object3);
            byte[] byArray2 = Utils.decodeBase64FromString((String)object2);
            object2 = byArray2;
            if (byArray2 == null) {
                throw new DecryptionError("Wrong base64 key text");
            }
            object2 = cipher.doFinal((byte[])object2);
            byte[] byArray3 = Utils.decodeBase64FromString((String)object);
            object = byArray3;
            if (byArray3 == null) {
                throw new DecryptionError("Wrong base64 message text");
            }
            object3 = Cipher.getInstance("AES/CBC/PKCS5PADDING");
            ((Cipher)object3).init(2, (Key)new SecretKeySpec((byte[])object2, "AES"), new IvParameterSpec((byte[])object, 0, 16));
            object = new String(((Cipher)object3).doFinal((byte[])object, 16, ((Object)object).length - 16), "UTF-8");
            return object;
        }
        catch (UnsupportedEncodingException | InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException exception) {
            FileLog.e((String)"ServerKeyManager", (String)"failed to decrypt server message", (Throwable)exception);
            this.a.removeValue("server_key_manager_private_data").removeValue("server_key_manager_public_data").commit();
            throw new DecryptionError(exception);
        }
        catch (Exception exception) {
            DebugUtils.safeThrow((String)"ServerKeyManager", (String)"failed to decrypt server message", (Throwable)exception);
            this.a.removeValue("server_key_manager_private_data").removeValue("server_key_manager_public_data").commit();
            throw new DecryptionError(exception);
        }
        finally {
            FileLog.v((String)"ServerKeyManager", (String)"decrypt message completed");
        }
    }

    final synchronized void b() {
        this.a.removeValue("server_key_manager_private_data").removeValue("server_key_manager_public_data").commit();
    }
}

