/*
 * Decompiled with CFR 0.152.
 */
package ru.mail.libverify.utils;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import ru.mail.libverify.api.VerificationFactory;
import ru.mail.libverify.api.g;
import ru.mail.notify.core.utils.DebugUtils;
import ru.mail.notify.core.utils.GCMTokenCheckType;
import ru.mail.notify.core.utils.IntentProcessServiceProcessor;
import ru.mail.notify.core.utils.components.BusMessageType;

public class AlarmReceiver
extends BroadcastReceiver {
    public void onReceive(Context context, Intent object) {
        if (context == null || object == null || object.getAction() == null) {
            return;
        }
        AlarmManager alarmManager = (AlarmManager)context.getSystemService("alarm");
        if (alarmManager == null) {
            return;
        }
        alarmManager.cancel(PendingIntent.getBroadcast((Context)context, (int)0, (Intent)object, (int)0));
        if (!VerificationFactory.hasInstallation(context)) {
            return;
        }
        new StringBuilder("received action ").append(object.getAction());
        alarmManager = null;
        block9 : switch (object.getAction()) {
            case "refresh_push_token_once": {
                alarmManager = new Intent(BusMessageType.GCM_REFRESH_TOKEN.name());
                alarmManager.putExtra("gcm_token_check_type", GCMTokenCheckType.ONCE.name());
                break;
            }
            case "refresh_push_token": {
                alarmManager = new Intent(BusMessageType.GCM_REFRESH_TOKEN.name());
                alarmManager.putExtra("gcm_token_check_type", GCMTokenCheckType.PERIODIC.name());
                break;
            }
            case "check_settings": {
                alarmManager = new Intent(BusMessageType.SERVICE_SETTINGS_CHECK.name());
                alarmManager.putExtra("settings_action_type", g.a.TIMER.name());
                break;
            }
            case "check_sms_templates": {
                alarmManager = new Intent(BusMessageType.SERVICE_SETTINGS_CHECK.name());
                alarmManager.putExtra("settings_action_type", g.a.SMS_TEMPLATES_CHECK.name());
                break;
            }
            case "package_changed": {
                switch (object.getStringExtra("package_change_type")) {
                    case "package_change_removed": {
                        alarmManager = new Intent(BusMessageType.SERVICE_SETTINGS_CHECK.name());
                        alarmManager.putExtra("settings_action_type", g.a.PACKAGE_REMOVED.name());
                        break block9;
                    }
                    case "package_change_updated": {
                        alarmManager = new Intent(BusMessageType.SERVICE_SETTINGS_CHECK.name());
                        alarmManager.putExtra("settings_action_type", g.a.PACKAGE_UPDATED.name());
                        break block9;
                    }
                }
                DebugUtils.safeThrow((String)"OldAlarmReceiver", (String)"failed to process broadcast", (Throwable)new IllegalArgumentException("unknown change type"));
                break;
            }
            case "unblock_notification": {
                object = object.getStringExtra("notification_id");
                alarmManager = new Intent(BusMessageType.SERVICE_SETTINGS_NOTIFICATION_UNBLOCK.name());
                alarmManager.putExtra("notification_id", (String)object);
                break;
            }
            case "app_started": {
                alarmManager = new Intent(BusMessageType.SERVICE_SETTINGS_CHECK.name());
                alarmManager.putExtra("settings_action_type", g.a.RESTART.name());
                break;
            }
            default: {
                DebugUtils.safeThrow((String)"OldAlarmReceiver", (String)"failed to process broadcast", (Throwable)new IllegalArgumentException("unknown action"));
            }
        }
        if (alarmManager != null) {
            IntentProcessServiceProcessor.start((Context)context, (Intent)alarmManager);
        }
    }
}

