/*
 * Decompiled with CFR 0.152.
 */
package ru.mail.libverify.utils;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import ru.mail.libverify.api.VerificationFactory;
import ru.mail.libverify.api.g;
import ru.mail.notify.core.utils.AlarmReceiver;
import ru.mail.notify.core.utils.GCMTokenCheckType;
import ru.mail.notify.core.utils.IntentProcessServiceProcessor;
import ru.mail.notify.core.utils.components.BusMessageType;

public class PackageStateReceiver
extends BroadcastReceiver {
    public void onReceive(Context context, Intent intent) {
        if (context == null || intent == null || TextUtils.isEmpty((CharSequence)intent.getAction())) {
            return;
        }
        String.format("received %s %s", intent.getAction(), intent.getData());
        switch (intent.getAction()) {
            case "android.intent.action.MY_PACKAGE_REPLACED": {
                if (VerificationFactory.hasInstallation(context)) {
                    intent = new Intent(BusMessageType.GCM_REFRESH_TOKEN.name());
                    intent.putExtra("gcm_token_check_type", GCMTokenCheckType.ONCE.name());
                    IntentProcessServiceProcessor.start((Context)context, (Intent)intent);
                    AlarmReceiver.create((Context)context, (boolean)false).setAction(BusMessageType.SERVICE_SETTINGS_CHECK.name()).setTimeout(3600000L).putExtra("settings_action_type", g.a.PACKAGE_UPDATED.name()).setUp();
                }
                return;
            }
            case "android.intent.action.PACKAGE_REMOVED": {
                if (VerificationFactory.hasInstallation(context)) {
                    AlarmReceiver.create((Context)context, (boolean)false).setAction(BusMessageType.SERVICE_SETTINGS_CHECK.name()).setTimeout(3600000L).putExtra("settings_action_type", g.a.PACKAGE_REMOVED.name()).setUp();
                }
                return;
            }
            case "android.intent.action.PACKAGE_REPLACED": {
                if (!TextUtils.equals((CharSequence)(intent.getData() == null ? null : intent.getData().toString()), (CharSequence)("package:" + context.getPackageName())) || !VerificationFactory.hasInstallation(context)) break;
                intent = new Intent(BusMessageType.GCM_REFRESH_TOKEN.name());
                intent.putExtra("gcm_token_check_type", GCMTokenCheckType.ONCE.name());
                IntentProcessServiceProcessor.start((Context)context, (Intent)intent);
                AlarmReceiver.create((Context)context, (boolean)false).setAction(BusMessageType.SERVICE_SETTINGS_CHECK.name()).setTimeout(3600000L).putExtra("settings_action_type", g.a.PACKAGE_UPDATED.name()).setUp();
            }
        }
    }
}

