package se.bjurr.bitbucketcloud.gen.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;



public class CommentContent   {
  

public enum MarkupEnum {

    MARKDOWN(String.valueOf("markdown")), CREOLE(String.valueOf("creole")), PLAINTEXT(String.valueOf("plaintext"));


    private String value;

    MarkupEnum (String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    @Override
    @JsonValue
    public String toString() {
        return String.valueOf(value);
    }

    @JsonCreator
    public static MarkupEnum fromValue(String v) {
        for (MarkupEnum b : MarkupEnum.values()) {
            if (String.valueOf(b.value).equals(v)) {
                return b;
            }
        }
        throw new IllegalArgumentException("Unexpected value '" + v + "'");
    }
}

  private @Valid MarkupEnum markup;
  private @Valid String raw;
  private @Valid String html;

  /**
   * The type of markup language the raw content is to be interpreted in.
   **/
  public CommentContent markup(MarkupEnum markup) {
    this.markup = markup;
    return this;
  }

  
  @ApiModelProperty(value = "The type of markup language the raw content is to be interpreted in.")
  @JsonProperty("markup")
  public MarkupEnum getMarkup() {
    return markup;
  }
  public void setMarkup(MarkupEnum markup) {
    this.markup = markup;
  }

  /**
   * The text as it was typed by a user.
   **/
  public CommentContent raw(String raw) {
    this.raw = raw;
    return this;
  }

  
  @ApiModelProperty(value = "The text as it was typed by a user.")
  @JsonProperty("raw")
  public String getRaw() {
    return raw;
  }
  public void setRaw(String raw) {
    this.raw = raw;
  }

  /**
   * The user&#39;s content rendered as HTML.
   **/
  public CommentContent html(String html) {
    this.html = html;
    return this;
  }

  
  @ApiModelProperty(value = "The user's content rendered as HTML.")
  @JsonProperty("html")
  public String getHtml() {
    return html;
  }
  public void setHtml(String html) {
    this.html = html;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CommentContent commentContent = (CommentContent) o;
    return Objects.equals(markup, commentContent.markup) &&
        Objects.equals(raw, commentContent.raw) &&
        Objects.equals(html, commentContent.html);
  }

  @Override
  public int hashCode() {
    return Objects.hash(markup, raw, html);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CommentContent {\n");
    
    sb.append("    markup: ").append(toIndentedString(markup)).append("\n");
    sb.append("    raw: ").append(toIndentedString(raw)).append("\n");
    sb.append("    html: ").append(toIndentedString(html)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

