package se.bjurr.bitbucketcloud.gen.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;



public class CommentInline   {
  
  private @Valid String path;
  private @Valid Integer from;
  private @Valid Integer to;

  /**
   * The path of the file this comment is anchored to.
   **/
  public CommentInline path(String path) {
    this.path = path;
    return this;
  }

  
  @ApiModelProperty(value = "The path of the file this comment is anchored to.")
  @JsonProperty("path")
  public String getPath() {
    return path;
  }
  public void setPath(String path) {
    this.path = path;
  }

  /**
   * The comment&#39;s anchor line in the old version of the file.
   * minimum: 1
   **/
  public CommentInline from(Integer from) {
    this.from = from;
    return this;
  }

  
  @ApiModelProperty(value = "The comment's anchor line in the old version of the file.")
  @JsonProperty("from")
 @Min(1)  public Integer getFrom() {
    return from;
  }
  public void setFrom(Integer from) {
    this.from = from;
  }

  /**
   * The comment&#39;s anchor line in the new version of the file.
   * minimum: 1
   **/
  public CommentInline to(Integer to) {
    this.to = to;
    return this;
  }

  
  @ApiModelProperty(value = "The comment's anchor line in the new version of the file.")
  @JsonProperty("to")
 @Min(1)  public Integer getTo() {
    return to;
  }
  public void setTo(Integer to) {
    this.to = to;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CommentInline commentInline = (CommentInline) o;
    return Objects.equals(path, commentInline.path) &&
        Objects.equals(from, commentInline.from) &&
        Objects.equals(to, commentInline.to);
  }

  @Override
  public int hashCode() {
    return Objects.hash(path, from, to);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CommentInline {\n");
    
    sb.append("    path: ").append(toIndentedString(path)).append("\n");
    sb.append("    from: ").append(toIndentedString(from)).append("\n");
    sb.append("    to: ").append(toIndentedString(to)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

