package se.bjurr.bitbucketcloud.gen.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import se.bjurr.bitbucketcloud.gen.model.Author;
import se.bjurr.bitbucketcloud.gen.model.BaseCommit;
import se.bjurr.bitbucketcloud.gen.model.Participant;
import se.bjurr.bitbucketcloud.gen.model.Repository;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;



public class Commit extends BaseCommit  {
  
  private @Valid List<Participant> participants = new ArrayList<Participant>();
  private @Valid Repository repository = null;

  /**
   **/
  public Commit participants(List<Participant> participants) {
    this.participants = participants;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("participants")
 @Size(min=0)  public List<Participant> getParticipants() {
    return participants;
  }
  public void setParticipants(List<Participant> participants) {
    this.participants = participants;
  }

  /**
   **/
  public Commit repository(Repository repository) {
    this.repository = repository;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("repository")
  public Repository getRepository() {
    return repository;
  }
  public void setRepository(Repository repository) {
    this.repository = repository;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Commit commit = (Commit) o;
    return Objects.equals(participants, commit.participants) &&
        Objects.equals(repository, commit.repository);
  }

  @Override
  public int hashCode() {
    return Objects.hash(participants, repository);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Commit {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    participants: ").append(toIndentedString(participants)).append("\n");
    sb.append("    repository: ").append(toIndentedString(repository)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

