package se.bjurr.bitbucketcloud.gen.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import se.bjurr.bitbucketcloud.gen.model.Account;
import se.bjurr.bitbucketcloud.gen.model.Repository;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;



public class DeployKey extends Object  {
  
  private @Valid Date addedOn;
  private @Valid Object links = null;
  private @Valid String label;
  private @Valid Repository repository = null;
  private @Valid Date lastUsed;
  private @Valid Account owner = null;
  private @Valid String key;
  private @Valid String comment;

  /**
   **/
  public DeployKey addedOn(Date addedOn) {
    this.addedOn = addedOn;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("added_on")
  public Date getAddedOn() {
    return addedOn;
  }
  public void setAddedOn(Date addedOn) {
    this.addedOn = addedOn;
  }

  /**
   **/
  public DeployKey links(Object links) {
    this.links = links;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("links")
  public Object getLinks() {
    return links;
  }
  public void setLinks(Object links) {
    this.links = links;
  }

  /**
   * The user-defined label for the deploy key
   **/
  public DeployKey label(String label) {
    this.label = label;
    return this;
  }

  
  @ApiModelProperty(value = "The user-defined label for the deploy key")
  @JsonProperty("label")
  public String getLabel() {
    return label;
  }
  public void setLabel(String label) {
    this.label = label;
  }

  /**
   **/
  public DeployKey repository(Repository repository) {
    this.repository = repository;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("repository")
  public Repository getRepository() {
    return repository;
  }
  public void setRepository(Repository repository) {
    this.repository = repository;
  }

  /**
   **/
  public DeployKey lastUsed(Date lastUsed) {
    this.lastUsed = lastUsed;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("last_used")
  public Date getLastUsed() {
    return lastUsed;
  }
  public void setLastUsed(Date lastUsed) {
    this.lastUsed = lastUsed;
  }

  /**
   **/
  public DeployKey owner(Account owner) {
    this.owner = owner;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("owner")
  public Account getOwner() {
    return owner;
  }
  public void setOwner(Account owner) {
    this.owner = owner;
  }

  /**
   * The deploy key value.
   **/
  public DeployKey key(String key) {
    this.key = key;
    return this;
  }

  
  @ApiModelProperty(value = "The deploy key value.")
  @JsonProperty("key")
  public String getKey() {
    return key;
  }
  public void setKey(String key) {
    this.key = key;
  }

  /**
   * The comment parsed from the deploy key (if present)
   **/
  public DeployKey comment(String comment) {
    this.comment = comment;
    return this;
  }

  
  @ApiModelProperty(value = "The comment parsed from the deploy key (if present)")
  @JsonProperty("comment")
  public String getComment() {
    return comment;
  }
  public void setComment(String comment) {
    this.comment = comment;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DeployKey deployKey = (DeployKey) o;
    return Objects.equals(addedOn, deployKey.addedOn) &&
        Objects.equals(links, deployKey.links) &&
        Objects.equals(label, deployKey.label) &&
        Objects.equals(repository, deployKey.repository) &&
        Objects.equals(lastUsed, deployKey.lastUsed) &&
        Objects.equals(owner, deployKey.owner) &&
        Objects.equals(key, deployKey.key) &&
        Objects.equals(comment, deployKey.comment);
  }

  @Override
  public int hashCode() {
    return Objects.hash(addedOn, links, label, repository, lastUsed, owner, key, comment);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DeployKey {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    addedOn: ").append(toIndentedString(addedOn)).append("\n");
    sb.append("    links: ").append(toIndentedString(links)).append("\n");
    sb.append("    label: ").append(toIndentedString(label)).append("\n");
    sb.append("    repository: ").append(toIndentedString(repository)).append("\n");
    sb.append("    lastUsed: ").append(toIndentedString(lastUsed)).append("\n");
    sb.append("    owner: ").append(toIndentedString(owner)).append("\n");
    sb.append("    key: ").append(toIndentedString(key)).append("\n");
    sb.append("    comment: ").append(toIndentedString(comment)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

