package se.bjurr.bitbucketcloud.gen.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Date;
import se.bjurr.bitbucketcloud.gen.model.Commit;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;



public class DeploymentRelease extends Object  {
  
  private @Valid String uuid;
  private @Valid Commit commit = null;
  private @Valid Date createdOn;
  private @Valid String url;
  private @Valid String name;

  /**
   * The UUID identifying the release.
   **/
  public DeploymentRelease uuid(String uuid) {
    this.uuid = uuid;
    return this;
  }

  
  @ApiModelProperty(value = "The UUID identifying the release.")
  @JsonProperty("uuid")
  public String getUuid() {
    return uuid;
  }
  public void setUuid(String uuid) {
    this.uuid = uuid;
  }

  /**
   **/
  public DeploymentRelease commit(Commit commit) {
    this.commit = commit;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("commit")
  public Commit getCommit() {
    return commit;
  }
  public void setCommit(Commit commit) {
    this.commit = commit;
  }

  /**
   * The timestamp when the release was created.
   **/
  public DeploymentRelease createdOn(Date createdOn) {
    this.createdOn = createdOn;
    return this;
  }

  
  @ApiModelProperty(value = "The timestamp when the release was created.")
  @JsonProperty("created_on")
  public Date getCreatedOn() {
    return createdOn;
  }
  public void setCreatedOn(Date createdOn) {
    this.createdOn = createdOn;
  }

  /**
   * Link to the pipeline that produced the release.
   **/
  public DeploymentRelease url(String url) {
    this.url = url;
    return this;
  }

  
  @ApiModelProperty(value = "Link to the pipeline that produced the release.")
  @JsonProperty("url")
  public String getUrl() {
    return url;
  }
  public void setUrl(String url) {
    this.url = url;
  }

  /**
   * The name of the release.
   **/
  public DeploymentRelease name(String name) {
    this.name = name;
    return this;
  }

  
  @ApiModelProperty(value = "The name of the release.")
  @JsonProperty("name")
  public String getName() {
    return name;
  }
  public void setName(String name) {
    this.name = name;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    DeploymentRelease deploymentRelease = (DeploymentRelease) o;
    return Objects.equals(uuid, deploymentRelease.uuid) &&
        Objects.equals(commit, deploymentRelease.commit) &&
        Objects.equals(createdOn, deploymentRelease.createdOn) &&
        Objects.equals(url, deploymentRelease.url) &&
        Objects.equals(name, deploymentRelease.name);
  }

  @Override
  public int hashCode() {
    return Objects.hash(uuid, commit, createdOn, url, name);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class DeploymentRelease {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    uuid: ").append(toIndentedString(uuid)).append("\n");
    sb.append("    commit: ").append(toIndentedString(commit)).append("\n");
    sb.append("    createdOn: ").append(toIndentedString(createdOn)).append("\n");
    sb.append("    url: ").append(toIndentedString(url)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

