package se.bjurr.bitbucketcloud.gen.model;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import se.bjurr.bitbucketcloud.gen.model.Account;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;



public class Group extends Object  {
  
  private @Valid Integer members;
  private @Valid Object links = null;
  private @Valid String slug;
  private @Valid String fullSlug;
  private @Valid String name;
  private @Valid Account owner = null;

  /**
   * The number of members in this group
   **/
  public Group members(Integer members) {
    this.members = members;
    return this;
  }

  
  @ApiModelProperty(value = "The number of members in this group")
  @JsonProperty("members")
  public Integer getMembers() {
    return members;
  }
  public void setMembers(Integer members) {
    this.members = members;
  }

  /**
   **/
  public Group links(Object links) {
    this.links = links;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("links")
  public Object getLinks() {
    return links;
  }
  public void setLinks(Object links) {
    this.links = links;
  }

  /**
   * The \&quot;sluggified\&quot; version of the group&#39;s name. This contains only ASCII characters and can therefore be slightly different than the name
   **/
  public Group slug(String slug) {
    this.slug = slug;
    return this;
  }

  
  @ApiModelProperty(value = "The \"sluggified\" version of the group's name. This contains only ASCII characters and can therefore be slightly different than the name")
  @JsonProperty("slug")
  public String getSlug() {
    return slug;
  }
  public void setSlug(String slug) {
    this.slug = slug;
  }

  /**
   * The concatenation of the owner&#39;s username and the group&#39;s slug, separated with a colon (e.g. &#x60;acme:developers&#x60;) 
   **/
  public Group fullSlug(String fullSlug) {
    this.fullSlug = fullSlug;
    return this;
  }

  
  @ApiModelProperty(value = "The concatenation of the owner's username and the group's slug, separated with a colon (e.g. `acme:developers`) ")
  @JsonProperty("full_slug")
  public String getFullSlug() {
    return fullSlug;
  }
  public void setFullSlug(String fullSlug) {
    this.fullSlug = fullSlug;
  }

  /**
   **/
  public Group name(String name) {
    this.name = name;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("name")
  public String getName() {
    return name;
  }
  public void setName(String name) {
    this.name = name;
  }

  /**
   **/
  public Group owner(Account owner) {
    this.owner = owner;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("owner")
  public Account getOwner() {
    return owner;
  }
  public void setOwner(Account owner) {
    this.owner = owner;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Group group = (Group) o;
    return Objects.equals(members, group.members) &&
        Objects.equals(links, group.links) &&
        Objects.equals(slug, group.slug) &&
        Objects.equals(fullSlug, group.fullSlug) &&
        Objects.equals(name, group.name) &&
        Objects.equals(owner, group.owner);
  }

  @Override
  public int hashCode() {
    return Objects.hash(members, links, slug, fullSlug, name, owner);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Group {\n");
    sb.append("    ").append(toIndentedString(super.toString())).append("\n");
    sb.append("    members: ").append(toIndentedString(members)).append("\n");
    sb.append("    links: ").append(toIndentedString(links)).append("\n");
    sb.append("    slug: ").append(toIndentedString(slug)).append("\n");
    sb.append("    fullSlug: ").append(toIndentedString(fullSlug)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    owner: ").append(toIndentedString(owner)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
}

